/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.util;

import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.reference.LoadedMods;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;

public final class EnchUtils {
    private static final int SOUL_BOUND_ID = EnchUtils.setSoulBoundID();
    private static final int TRANSLUCENCY_ID = EnchUtils.setTranslucencyID();

    private EnchUtils() {
    }

    private static int setSoulBoundID() {
        if (!ConfigHandler.allowSoulBound) {
            return -3;
        }
        if (!LoadedMods.ENDERIO) {
            return -2;
        }
        for (Enchantment ench : Enchantment.field_77331_b) {
            if (ench == null || !ench.func_77320_a().equals("enchantment.enderio.soulBound")) continue;
            return ench.field_77352_x;
        }
        return -1;
    }

    private static int setTranslucencyID() {
        if (!ConfigHandler.allowTranslucency) {
            return -3;
        }
        if (!LoadedMods.WITCHINGGADGETS) {
            return -2;
        }
        for (Enchantment ench : Enchantment.field_77331_b) {
            if (ench == null || !ench.func_77320_a().equals("enchantment.wg.invisibleGear")) continue;
            return ench.field_77352_x;
        }
        return -1;
    }

    public static boolean isSoulBounded(ItemStack stack) {
        if (SOUL_BOUND_ID > 0) {
            return EnchantmentHelper.func_77506_a((int)SOUL_BOUND_ID, (ItemStack)stack) > 0;
        }
        return false;
    }

    public static int getTranslucencyLevel(ItemStack stack) {
        if (TRANSLUCENCY_ID > 0) {
            return EnchantmentHelper.func_77506_a((int)TRANSLUCENCY_ID, (ItemStack)stack);
        }
        return 0;
    }

    public static boolean isSoulBook(ItemStack book) {
        if (EnchantmentHelper.func_82781_a((ItemStack)book).size() == 1) {
            return EnchantmentHelper.func_82781_a((ItemStack)book).get(SOUL_BOUND_ID) != null;
        }
        return false;
    }

    public static boolean isTranslucencyBook(ItemStack book) {
        if (EnchantmentHelper.func_82781_a((ItemStack)book).size() == 1) {
            return EnchantmentHelper.func_82781_a((ItemStack)book).get(TRANSLUCENCY_ID) != null;
        }
        return false;
    }
}

