/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import openmods.calc.BinaryFunction;
import openmods.calc.Environment;
import openmods.calc.Frame;
import openmods.calc.UnaryFunction;
import openmods.calc.types.multi.Cons;
import openmods.calc.types.multi.MetaObject;
import openmods.calc.types.multi.MetaObjectInfo;
import openmods.calc.types.multi.MetaObjectUtils;
import openmods.calc.types.multi.SimpleNamespace;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypeUserdata;
import openmods.calc.types.multi.TypedValue;
import openmods.utils.OptionalInt;
import openmods.utils.Stack;

public class MetaObjectSymbols {
    private static final String ATTR_NAME = "name";
    private static final String ATTR_INFO = "info";
    private static final String ATTR_CAPABILITIES = "slots";

    private static MetaObject.Builder createBuilderFromArgs(Iterable<TypedValue> args) {
        MetaObject.Builder result = MetaObject.builder();
        for (TypedValue arg : args) {
            if (arg.is(MetaObjectSlot.class)) {
                MetaObjectSlot nativeSlot = arg.as(MetaObjectSlot.class);
                nativeSlot.info.set(result, nativeSlot.slot);
                continue;
            }
            if (arg.is(Cons.class)) {
                Cons pair = arg.as(Cons.class);
                MetaObjectInfo.SlotAccess slotInfo = pair.car.as(MetaObjectInfo.SlotAccess.class, "slot:value pair");
                TypedValue slotValue = pair.cdr;
                if (slotValue.is(MetaObjectSlot.class)) {
                    MetaObjectSlot nativeSlot = slotValue.as(MetaObjectSlot.class);
                    Preconditions.checkState((nativeSlot.info == slotInfo ? 1 : 0) != 0, (String)"Invalid slot type for name %s, got %s", (Object[])new Object[]{slotInfo.name, ((MetaObjectSlot)nativeSlot).info.name});
                    slotInfo.set(result, nativeSlot.slot);
                    continue;
                }
                if (MetaObjectUtils.isCallable(slotValue)) {
                    MetaObject.Slot slot = slotInfo.adapter.wrap(slotValue);
                    slotInfo.set(result, slot);
                    continue;
                }
                throw new IllegalArgumentException("Slot value must be native slot or callable");
            }
            throw new IllegalArgumentException("Expected native slot or slot:value pair");
        }
        return result;
    }

    public static void register(Environment<TypedValue> env) {
        TypedValue nullValue = env.nullValue();
        final TypeDomain domain = nullValue.domain;
        domain.registerType(MetaObjectInfo.SlotAccess.class, "metaobjectslot", MetaObjectSymbols.createCapabilityMetaObject());
        TypedValue metaObjectSlotType = domain.create(TypeUserdata.class, new TypeUserdata("metaobjectslotvalue", MetaObjectSlot.class));
        env.setGlobalSymbol("metaobjectslotvalue", metaObjectSlotType);
        domain.registerType(MetaObjectSlot.class, "metaobjectslotvalue", MetaObjectSymbols.createMetaObjectSlotMetaObject(metaObjectSlotType));
        TypedValue metaObjectType = domain.create(TypeUserdata.class, new TypeUserdata("metaobject", MetaObject.class), TypeUserdata.defaultMetaObject(domain).set(new MetaObject.SlotCall(){

            @Override
            public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
                Preconditions.checkState((boolean)argumentsCount.isPresent(), (Object)"'metaobject' symbol requires arguments count");
                Stack<TypedValue> stack = frame.stack().substack(argumentsCount.get());
                MetaObject.Builder builder = MetaObjectSymbols.createBuilderFromArgs(stack);
                stack.clear();
                stack.push(domain.create(MetaObject.class, builder.build()));
            }
        }).build());
        env.setGlobalSymbol("metaobject", metaObjectType);
        domain.registerType(MetaObject.class, "metaobject", MetaObjectSymbols.createMetaObjectMetaObject(domain, metaObjectType, nullValue));
        HashMap slots = Maps.newHashMap();
        for (Map.Entry<String, MetaObjectInfo.SlotAccess> e : MetaObjectInfo.slots.entrySet()) {
            slots.put(e.getKey(), domain.create(MetaObjectInfo.SlotAccess.class, e.getValue()));
        }
        env.setGlobalSymbol(ATTR_CAPABILITIES, domain.create(SimpleNamespace.class, new SimpleNamespace(slots)));
        env.setGlobalSymbol("has", (TypedValue)((Object)new SlotCheckSymbol()));
        env.setGlobalSymbol("getmetaobject", (TypedValue)((Object)new UnaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call(TypedValue value) {
                return value.domain.create(MetaObject.class, value.getMetaObject());
            }
        }));
        env.setGlobalSymbol("setmetaobject", (TypedValue)((Object)new BinaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call(TypedValue left, TypedValue right) {
                MetaObject mo = right.as(MetaObject.class, "second 'setmetaobject' arg");
                return left.updateMetaObject(mo);
            }
        }));
    }

    private static MetaObject createCapabilityMetaObject() {
        return MetaObject.builder().set(new MetaObject.SlotDecompose(){

            @Override
            public Optional<List<TypedValue>> tryDecompose(TypedValue self, TypedValue input, int variableCount, Frame<TypedValue> frame) {
                MetaObjectInfo.SlotAccess info = self.as(MetaObjectInfo.SlotAccess.class);
                MetaObject mo = input.getMetaObject();
                if (info.isPresent.apply((Object)mo)) {
                    ImmutableList result = ImmutableList.of((Object)input);
                    return Optional.of((Object)result);
                }
                return Optional.absent();
            }
        }).set(new MetaObject.SlotCall(){

            @Override
            public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
                TypedValue target;
                MetaObject mo;
                MetaObjectInfo.SlotAccess info = self.as(MetaObjectInfo.SlotAccess.class);
                MetaObject.Slot slot = info.get(mo = (target = frame.stack().peek(argumentsCount.get() - 1)).getMetaObject());
                Preconditions.checkState((slot != null ? 1 : 0) != 0, (String)"Value %s has no slot %s", (Object[])new Object[]{target});
                info.adapter.call(slot, frame, argumentsCount, returnsCount);
            }
        }).set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                return "slots." + self.as(MetaObjectInfo.SlotAccess.class).name;
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                return "slots." + self.as(MetaObjectInfo.SlotAccess.class).name;
            }
        }).build();
    }

    private static MetaObject createMetaObjectSlotMetaObject(TypedValue metaObjectSlotType) {
        return MetaObject.builder().set(new MetaObject.SlotCall(){

            @Override
            public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
                MetaObjectSlot slot = self.as(MetaObjectSlot.class);
                ((MetaObjectSlot)slot).info.adapter.call(slot.slot, frame, argumentsCount, returnsCount);
            }
        }).set(new MetaObject.SlotAttr(){

            @Override
            public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
                MetaObjectSlot slot = self.as(MetaObjectSlot.class);
                TypeDomain domain = self.domain;
                if (key.equals(MetaObjectSymbols.ATTR_NAME)) {
                    return Optional.of((Object)domain.create(String.class, ((MetaObjectSlot)slot).info.name));
                }
                if (key.equals(MetaObjectSymbols.ATTR_INFO)) {
                    return Optional.of((Object)domain.create(MetaObjectInfo.SlotAccess.class, slot.info));
                }
                return Optional.absent();
            }
        }).set(MetaObjectUtils.dirFromArray(ATTR_NAME, ATTR_INFO)).set(MetaObjectUtils.typeConst(metaObjectSlotType)).build();
    }

    private static MetaObject createMetaObjectMetaObject(final TypeDomain domain, TypedValue metaObjectType, final TypedValue nullValue) {
        return MetaObject.builder().set(new MetaObject.SlotAttr(){

            @Override
            public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
                MetaObject mo = self.as(MetaObject.class);
                MetaObjectInfo.SlotAccess slotInfo = MetaObjectInfo.slots.get(key);
                if (slotInfo == null) {
                    return Optional.absent();
                }
                MetaObject.Slot slot = slotInfo.get(mo);
                TypedValue result = slot == null ? nullValue : (slot instanceof MetaObject.SlotWithValue ? ((MetaObject.SlotWithValue)slot).getValue() : domain.create(MetaObjectSlot.class, new MetaObjectSlot(slot, slotInfo)));
                return Optional.of((Object)result);
            }
        }).set(MetaObjectUtils.dirFromIterable(MetaObjectInfo.slots.keySet())).set(new MetaObject.SlotCall(){

            @Override
            public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
                Preconditions.checkState((boolean)argumentsCount.isPresent(), (Object)"'metaobject' symbol requires arguments count");
                MetaObject mo = self.as(MetaObject.class);
                Stack<TypedValue> stack = frame.stack().substack(argumentsCount.get());
                MetaObject.Builder builder = MetaObjectSymbols.createBuilderFromArgs(stack);
                stack.clear();
                stack.push(domain.create(MetaObject.class, builder.update(mo)));
            }
        }).set(MetaObjectUtils.typeConst(metaObjectType)).build();
    }

    private static class MetaObjectSlot {
        private final MetaObject.Slot slot;
        private final MetaObjectInfo.SlotAccess info;

        public MetaObjectSlot(MetaObject.Slot slot, MetaObjectInfo.SlotAccess info) {
            this.slot = slot;
            this.info = info;
        }
    }

    private static class SlotCheckSymbol
    extends BinaryFunction.Direct<TypedValue> {
        private SlotCheckSymbol() {
        }

        @Override
        protected TypedValue call(TypedValue left, TypedValue right) {
            MetaObject mo = left.getMetaObject();
            MetaObjectInfo.SlotAccess info = right.as(MetaObjectInfo.SlotAccess.class, "second 'can' argument");
            return left.domain.create(Boolean.class, info.isPresent.apply((Object)mo));
        }
    }
}

