/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer;

import org.lwjgl.opengl.GL11;

public abstract class DisplayListWrapper {
    private int displayList;
    private boolean isValid;
    private boolean pendingInvalidate;

    public boolean isCompiled() {
        return this.isValid;
    }

    public void render() {
        if (this.pendingInvalidate) {
            this.reset();
        }
        if (!this.isValid) {
            this.displayList = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.displayList, (int)4864);
            this.compile();
            GL11.glEndList();
            this.isValid = true;
        }
        GL11.glCallList((int)this.displayList);
    }

    public abstract void compile();

    public void reset() {
        if (this.isValid) {
            GL11.glDeleteLists((int)this.displayList, (int)1);
        }
        this.isValid = false;
        this.pendingInvalidate = false;
    }

    public void invalidate() {
        this.pendingInvalidate = true;
    }
}

