/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.shapes.IShapeable;
import openmods.utils.Coord;
import openmods.utils.MathUtils;

public class GeometryUtils {
    public static void makeLine(int startX, int startY, int startZ, Axis axis, int length, IShapeable shapeable) {
        GeometryUtils.makeLine(startX, startY, startZ, axis.positive, length, shapeable);
    }

    public static void makeLine(int startX, int startY, int startZ, ForgeDirection direction, int length, IShapeable shapeable) {
        if (length < 0) {
            return;
        }
        for (int offset = 0; offset <= length; ++offset) {
            shapeable.setBlock(startX + offset * direction.offsetX, startY + offset * direction.offsetY, startZ + offset * direction.offsetZ);
        }
    }

    public static void makePlane(int startX, int startY, int startZ, int width, int height, Axis right, Axis up, IShapeable shapeable) {
        GeometryUtils.makePlane(startX, startY, startZ, width, height, right.positive, up.positive, shapeable);
    }

    public static void makePlane(int startX, int startY, int startZ, int width, int height, ForgeDirection right, ForgeDirection up, IShapeable shapeable) {
        if (width < 0 || height < 0) {
            return;
        }
        for (int h = 0; h <= height; ++h) {
            int lineOffsetX = startX + h * up.offsetX;
            int lineOffsetY = startY + h * up.offsetY;
            int lineOffsetZ = startZ + h * up.offsetZ;
            GeometryUtils.makeLine(lineOffsetX, lineOffsetY, lineOffsetZ, right, width, shapeable);
        }
    }

    @Deprecated
    public static void makeSphere(int radiusX, int radiusY, int radiusZ, IShapeable shapeable, EnumSet<Octant> octants) {
        GeometryUtils.makeEllipsoid(radiusX, radiusY, radiusZ, shapeable, octants);
    }

    public static void makeEllipsoid(int radiusX, int radiusY, int radiusZ, IShapeable shapeable, Set<Octant> octants) {
        ImmutableList octantsList = ImmutableList.copyOf(octants);
        double invRadiusX = 1.0 / ((double)radiusX + 0.5);
        double invRadiusY = 1.0 / ((double)radiusY + 0.5);
        double invRadiusZ = 1.0 / ((double)radiusZ + 0.5);
        double nextXn = 0.0;
        block0: for (int x = 0; x <= radiusX; ++x) {
            double xn = nextXn;
            nextXn += invRadiusX;
            double nextYn = 0.0;
            block1: for (int y = 0; y <= radiusY; ++y) {
                double yn = nextYn;
                nextYn += invRadiusY;
                double nextZn = 0.0;
                for (int z = 0; z <= radiusZ; ++z) {
                    double zn = nextZn;
                    nextZn += invRadiusZ;
                    double distanceSq = MathUtils.lengthSq(xn, yn, zn);
                    if (distanceSq > 1.0) {
                        if (z != 0) continue block1;
                        if (y != 0) continue block0;
                        break block0;
                    }
                    if (MathUtils.lengthSq(nextXn, yn, zn) <= 1.0 && MathUtils.lengthSq(xn, nextYn, zn) <= 1.0 && MathUtils.lengthSq(xn, yn, nextZn) <= 1.0) continue;
                    for (Octant octant : octantsList) {
                        shapeable.setBlock(x * octant.x, y * octant.y, z * octant.z);
                    }
                }
            }
        }
    }

    public static void makeEllipsoid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IShapeable shapeable, Set<Octant> octants) {
        int radiusZ;
        int radiusY;
        int radiusX;
        final int centerX = (minX + maxX) / 2;
        final int centerY = (minY + maxY) / 2;
        final int centerZ = (minZ + maxZ) / 2;
        final IShapeable prevShapeable = shapeable;
        shapeable = new IShapeable(){

            @Override
            public void setBlock(int x, int y, int z) {
                prevShapeable.setBlock(centerX + x, centerY + y, centerZ + z);
            }
        };
        int diffX = maxX - minX;
        if ((diffX & 1) == 0) {
            radiusX = diffX / 2;
        } else {
            radiusX = diffX / 2 + 1;
            shapeable = GeometryUtils.skipMiddleX(shapeable);
        }
        int diffY = maxY - minY;
        if ((diffY & 1) == 0) {
            radiusY = diffY / 2;
        } else {
            radiusY = diffY / 2 + 1;
            shapeable = GeometryUtils.skipMiddleY(shapeable);
        }
        int diffZ = maxZ - minZ;
        if ((diffZ & 1) == 0) {
            radiusZ = diffZ / 2;
        } else {
            radiusZ = diffZ / 2 + 1;
            shapeable = GeometryUtils.skipMiddleZ(shapeable);
        }
        GeometryUtils.makeEllipsoid(radiusX, radiusY, radiusZ, shapeable, octants);
    }

    public static void makeEllipse(int radiusX, int radiusZ, int y, IShapeable shapeable, Set<Quadrant> quadrants) {
        double invRadiusX = 1.0 / ((double)radiusX + 0.5);
        double invRadiusZ = 1.0 / ((double)radiusZ + 0.5);
        ImmutableList quadrantsList = ImmutableList.copyOf(quadrants);
        double nextXn = 0.0;
        block0: for (int x = 0; x <= radiusX; ++x) {
            double xn = nextXn;
            nextXn += invRadiusX;
            double nextZn = 0.0;
            for (int z = 0; z <= radiusZ; ++z) {
                double zn = nextZn;
                nextZn += invRadiusZ;
                double distanceSq = MathUtils.lengthSq(xn, zn);
                if (distanceSq > 1.0) {
                    if (z != 0) continue block0;
                    break block0;
                }
                if (MathUtils.lengthSq(nextXn, zn) <= 1.0 && MathUtils.lengthSq(xn, nextZn) <= 1.0) continue;
                for (Quadrant quadrant : quadrantsList) {
                    shapeable.setBlock(x * quadrant.x, y, z * quadrant.z);
                }
            }
        }
    }

    public static void makeEllipse(int minX, int minZ, int maxX, int maxZ, int y, IShapeable shapeable, Set<Quadrant> quadrants) {
        int radiusZ;
        int radiusX;
        final int centerX = (minX + maxX) / 2;
        final int centerZ = (minZ + maxZ) / 2;
        final IShapeable prevShapeable = shapeable;
        shapeable = new IShapeable(){

            @Override
            public void setBlock(int x, int y, int z) {
                prevShapeable.setBlock(centerX + x, y, centerZ + z);
            }
        };
        int diffX = maxX - minX;
        if ((diffX & 1) == 0) {
            radiusX = diffX / 2;
        } else {
            radiusX = diffX / 2 + 1;
            shapeable = GeometryUtils.skipMiddleX(shapeable);
        }
        int diffY = maxZ - minZ;
        if ((diffY & 1) == 0) {
            radiusZ = diffY / 2;
        } else {
            radiusZ = diffY / 2 + 1;
            shapeable = GeometryUtils.skipMiddleZ(shapeable);
        }
        GeometryUtils.makeEllipse(radiusX, radiusZ, y, shapeable, quadrants);
    }

    private static IShapeable skipMiddleX(final IShapeable shapeable) {
        return new IShapeable(){

            @Override
            public void setBlock(int x, int y, int z) {
                if (x != 0) {
                    if (x < 0) {
                        shapeable.setBlock(x + 1, y, z);
                    } else {
                        shapeable.setBlock(x, y, z);
                    }
                }
            }
        };
    }

    private static IShapeable skipMiddleY(final IShapeable shapeable) {
        return new IShapeable(){

            @Override
            public void setBlock(int x, int y, int z) {
                if (y != 0) {
                    if (y < 0) {
                        shapeable.setBlock(x, y + 1, z);
                    } else {
                        shapeable.setBlock(x, y, z);
                    }
                }
            }
        };
    }

    private static IShapeable skipMiddleZ(final IShapeable shapeable) {
        return new IShapeable(){

            @Override
            public void setBlock(int x, int y, int z) {
                if (z != 0) {
                    if (z < 0) {
                        shapeable.setBlock(x, y, z + 1);
                    } else {
                        shapeable.setBlock(x, y, z);
                    }
                }
            }
        };
    }

    public static void line2D(int y, int x0, int z0, int x1, int z1, IShapeable shapeable) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = -Math.abs(z1 - z0);
        int sy = z0 < z1 ? 1 : -1;
        int err = dx + dy;
        while (true) {
            shapeable.setBlock(x0, y, z0);
            if (x0 == x1 && z0 == z1) break;
            int e2 = 2 * err;
            if (e2 >= dy) {
                err += dy;
                x0 += sx;
            }
            if (e2 > dx) continue;
            err += dx;
            z0 += sy;
        }
    }

    public static void line3D(Vec3 start, Vec3 end, IShapeable shapeable) {
        GeometryUtils.line3D((int)start.field_72450_a, (int)start.field_72448_b, (int)start.field_72449_c, (int)end.field_72450_a, (int)end.field_72448_b, (int)end.field_72449_c, shapeable);
    }

    public static void line3D(Coord start, Coord end, IShapeable shapeable) {
        GeometryUtils.line3D(start.x, start.y, start.z, end.x, end.y, end.z, shapeable);
    }

    public static void line3D(int startX, int startY, int startZ, int endX, int endY, int endZ, IShapeable shapeable) {
        int dx = endX - startX;
        int dy = endY - startY;
        int dz = endZ - startZ;
        int ax = Math.abs(dx) << 1;
        int ay = Math.abs(dy) << 1;
        int az = Math.abs(dz) << 1;
        int signx = Integer.signum(dx);
        int signy = Integer.signum(dy);
        int signz = Integer.signum(dz);
        int x = startX;
        int y = startY;
        int z = startZ;
        if (ax >= Math.max(ay, az)) {
            int deltay = ay - (ax >> 1);
            int deltaz = az - (ax >> 1);
            while (true) {
                shapeable.setBlock(x, y, z);
                if (x == endX) {
                    return;
                }
                if (deltay >= 0) {
                    y += signy;
                    deltay -= ax;
                }
                if (deltaz >= 0) {
                    z += signz;
                    deltaz -= ax;
                }
                x += signx;
                deltay += ay;
                deltaz += az;
            }
        }
        if (ay >= Math.max(ax, az)) {
            int deltax = ax - (ay >> 1);
            int deltaz = az - (ay >> 1);
            while (true) {
                shapeable.setBlock(x, y, z);
                if (y == endY) {
                    return;
                }
                if (deltax >= 0) {
                    x += signx;
                    deltax -= ay;
                }
                if (deltaz >= 0) {
                    z += signz;
                    deltaz -= ay;
                }
                y += signy;
                deltax += ax;
                deltaz += az;
            }
        }
        if (az >= Math.max(ax, ay)) {
            int deltax = ax - (az >> 1);
            int deltay = ay - (az >> 1);
            while (true) {
                shapeable.setBlock(x, y, z);
                if (z == endZ) {
                    return;
                }
                if (deltax >= 0) {
                    x += signx;
                    deltax -= az;
                }
                if (deltay >= 0) {
                    y += signy;
                    deltay -= az;
                }
                z += signz;
                deltax += ax;
                deltay += ay;
            }
        }
    }

    public static double normalizeAngle(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    public static double compareAngles(double current, double target) {
        current = GeometryUtils.normalizeAngle(current);
        target = GeometryUtils.normalizeAngle(target);
        return Math.signum(target - current);
    }

    public static double getAngleDistance(double current, double target) {
        double result = target - current;
        return Math.abs(result) > 180.0 ? 180.0 - result : result;
    }

    public static enum Quadrant {
        TopSouthWest(-1, 1),
        TopNorthEast(1, -1),
        TopNorthWest(-1, -1),
        TopSouthEast(1, 1);

        public static final EnumSet<Quadrant> ALL;
        public final int x;
        public final int z;

        private Quadrant(int x, int z) {
            this.x = x;
            this.z = z;
        }

        static {
            ALL = EnumSet.allOf(Quadrant.class);
        }
    }

    public static enum Octant {
        TopSouthWest("Top South West", ForgeDirection.WEST, ForgeDirection.UP, ForgeDirection.SOUTH),
        TopNorthEast("Top North East", ForgeDirection.EAST, ForgeDirection.UP, ForgeDirection.NORTH),
        TopNorthWest("Top North West", ForgeDirection.WEST, ForgeDirection.UP, ForgeDirection.NORTH),
        TopSouthEast("Top South East", ForgeDirection.EAST, ForgeDirection.UP, ForgeDirection.SOUTH),
        BottomSouthWest("Bottom South West", ForgeDirection.WEST, ForgeDirection.DOWN, ForgeDirection.SOUTH),
        BottomNorthEast("Bottom North East", ForgeDirection.EAST, ForgeDirection.DOWN, ForgeDirection.NORTH),
        BottomNorthWest("Bottom North West", ForgeDirection.WEST, ForgeDirection.DOWN, ForgeDirection.NORTH),
        BottomSouthEast("Bottom South East", ForgeDirection.EAST, ForgeDirection.DOWN, ForgeDirection.SOUTH);

        public static final EnumSet<Octant> ALL;
        public static final EnumSet<Octant> TOP;
        public static final EnumSet<Octant> BOTTOM;
        public static final EnumSet<Octant> NORTH;
        public static final EnumSet<Octant> SOUTH;
        public static final EnumSet<Octant> EAST;
        public static final EnumSet<Octant> WEST;
        public final EnumSet<ForgeDirection> dirs;
        public final int x;
        public final int y;
        public final int z;
        public final String name;

        public int getXOffset() {
            return this.x;
        }

        public int getYOffset() {
            return this.y;
        }

        public int getZOffset() {
            return this.z;
        }

        public String getFriendlyName() {
            return this.name;
        }

        private Octant(String friendlyName, ForgeDirection dirX, ForgeDirection dirY, ForgeDirection dirZ) {
            this.x = dirX.offsetX + dirY.offsetX + dirZ.offsetX;
            this.y = dirX.offsetY + dirY.offsetY + dirZ.offsetY;
            this.z = dirX.offsetZ + dirY.offsetZ + dirZ.offsetZ;
            this.dirs = EnumSet.of(dirX, dirY, dirZ);
            this.name = friendlyName;
        }

        private static EnumSet<Octant> select(ForgeDirection dir) {
            Set result = Sets.newIdentityHashSet();
            for (Octant o : Octant.values()) {
                if (!o.dirs.contains(dir)) continue;
                result.add(o);
            }
            return EnumSet.copyOf(result);
        }

        static {
            ALL = EnumSet.allOf(Octant.class);
            TOP = Octant.select(ForgeDirection.UP);
            BOTTOM = Octant.select(ForgeDirection.DOWN);
            NORTH = Octant.select(ForgeDirection.NORTH);
            SOUTH = Octant.select(ForgeDirection.SOUTH);
            EAST = Octant.select(ForgeDirection.EAST);
            WEST = Octant.select(ForgeDirection.WEST);
        }
    }

    public static enum Axis {
        X(1, 0, 0, ForgeDirection.EAST, ForgeDirection.WEST),
        Y(0, 1, 0, ForgeDirection.UP, ForgeDirection.DOWN),
        Z(0, 0, 1, ForgeDirection.SOUTH, ForgeDirection.NORTH);

        public final int dx;
        public final int dy;
        public final int dz;
        public final ForgeDirection positive;
        public final ForgeDirection negative;

        private Axis(int dx, int dy, int dz, ForgeDirection positive, ForgeDirection negative) {
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
            this.positive = positive;
            this.negative = negative;
        }
    }
}

