/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib;

import com.gtnewhorizon.gtnhlib.util.map.ItemStackMap;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import cpw.mods.fml.common.Loader;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;

public class ChannelDescription {
    private static final ItemStackMap<Set<ChannelDescription>> itemToChannels = new ItemStackMap(true);
    private static final Map<String, ChannelDescription> registry = new HashMap<String, ChannelDescription>();
    private final String channel;
    private final Map<String, String> descriptions = new HashMap<String, String>();
    private final ItemStackMap<Integer> items = new ItemStackMap(true);

    public static ChannelDescription get(String channel) {
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        return registry.computeIfAbsent(channel, ChannelDescription::new);
    }

    public static boolean has(String channel) {
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        return registry.containsKey(channel);
    }

    public static Collection<Map.Entry<String, Integer>> iterate(ItemStack block) {
        Set channels = (Set)itemToChannels.get((Object)block);
        if (channels == null) {
            return Collections.emptySet();
        }
        return channels.stream().map(d -> new AbstractMap.SimpleImmutableEntry<String, Integer>(d.channel, (Integer)d.items.get((Object)block))).collect(Collectors.toList());
    }

    public static void set(String channel, String modid, String description) {
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        registry.computeIfAbsent(channel, ChannelDescription::new).add(modid, description);
    }

    public static void item(String channel, int channelValue, ItemStack stack) {
        if (StructureLibAPI.isDebugEnabled()) {
            if (!channel.toLowerCase(Locale.ROOT).equals(channel)) {
                throw new IllegalArgumentException("Channel name can be lower case ONLY");
            }
            if (channelValue <= 0) {
                throw new IllegalArgumentException("Channel value must be greater than 0");
            }
        }
        ChannelDescription inst = registry.computeIfAbsent(channel, ChannelDescription::new);
        inst.items.put(stack, (Object)channelValue);
        ((Set)itemToChannels.computeIfAbsent(stack, s -> new HashSet())).add(inst);
    }

    public static Map<String, ChannelDescription> getAll() {
        return Collections.unmodifiableMap(registry);
    }

    private ChannelDescription(String channel) {
        this.channel = channel;
    }

    public String getChannel() {
        return this.channel;
    }

    public ChannelDescription add(String modid, String description) {
        if (Loader.instance().getIndexedModList().get(modid) == null) {
            throw new IllegalArgumentException("Mod not found: " + modid);
        }
        this.descriptions.put(modid, description);
        return this;
    }

    public Map<String, String> getDescriptions() {
        return Collections.unmodifiableMap(this.descriptions);
    }

    public Map<ItemStack, Integer> getItems() {
        return Collections.unmodifiableMap(this.items);
    }
}

