/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import shukaro.warptheory.util.FormatCodes;

public class ChatHelper {
    private static Random rand = new Random();

    public static void sendToPlayer(EntityPlayer player, String message) {
        player.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    public static void sendToAll(String message) {
        MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(message));
    }

    public static void sendToWorld(World world, String message) {
        for (EntityPlayer player : world.field_73010_i) {
            player.func_145747_a((IChatComponent)new ChatComponentText(message));
        }
    }

    public static String getUsername(IChatComponent message) {
        if (!message.func_150260_c().contains("<") || !message.func_150260_c().contains(">")) {
            return "";
        }
        return message.func_150260_c().split(" ")[0].replace("<", "").replace(">", "");
    }

    @SideOnly(value=Side.CLIENT)
    public static String getFormattedUsername(IChatComponent message) {
        if (!message.func_150254_d().contains("<") || !message.func_150254_d().contains(">")) {
            return "";
        }
        return message.func_150254_d().split(" ")[0];
    }

    public static String getText(IChatComponent message) {
        return message.func_150260_c().replaceFirst("<.*> ", "");
    }

    @SideOnly(value=Side.CLIENT)
    public static String getFormattedText(IChatComponent message) {
        return message.func_150254_d().replaceFirst("<.*> ", "");
    }

    public static String garbleMessage(IChatComponent message) {
        String text = ChatHelper.getText(message);
        String newText = "";
        for (String word : text.split("\\s+")) {
            String newWord = "";
            for (int i = 0; i < word.length(); ++i) {
                String c;
                if (word.charAt(i) == '\u00a7') {
                    c = String.valueOf(word.charAt(i) + String.valueOf(word.charAt(i + 1)));
                    ++i;
                } else {
                    c = rand.nextInt(5) == 0 ? FormatCodes.RandomChar.code + String.valueOf(word.charAt(i)) + FormatCodes.Reset.code : String.valueOf(word.charAt(i));
                }
                newWord = rand.nextBoolean() ? newWord + c : c + newWord;
            }
            newText = rand.nextBoolean() ? newText + (newWord.length() > 0 && newText.length() > 0 ? " " : "") + newWord : newWord + (newWord.length() > 0 && newText.length() > 0 ? " " : "") + newText;
        }
        return FormatCodes.Reset.code + newText + FormatCodes.Reset.code;
    }
}

