/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.network.packets;

import com.rwtema.extrautils.helper.XUHelper;
import com.rwtema.extrautils.network.NetworkHandler;
import com.rwtema.extrautils.network.XUPacketBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class PacketTempChatMultiline
extends XUPacketBase {
    IChatComponent[] chat;
    static final int START_ID = 983423323;
    static int lastNum = 0;
    static ThreadLocal<List<IChatComponent>> chatComponents = new ThreadLocal<List<IChatComponent>>(){

        @Override
        protected List<IChatComponent> initialValue() {
            return new ArrayList<IChatComponent>();
        }
    };

    public PacketTempChatMultiline() {
    }

    public PacketTempChatMultiline(List<String> chat) {
        this.chat = new IChatComponent[chat.size()];
        for (int i = 0; i < chat.size(); ++i) {
            this.chat[i] = new ChatComponentText(chat.get(i));
        }
    }

    public PacketTempChatMultiline(IChatComponent[] chat) {
        this.chat = chat;
    }

    @Override
    public void writeData(ByteBuf data) throws Exception {
        data.writeShort(this.chat.length);
        for (IChatComponent iChatComponent : this.chat) {
            this.writeChatComponent(data, iChatComponent);
        }
    }

    @Override
    public void readData(EntityPlayer player, ByteBuf data) {
        this.chat = new IChatComponent[data.readUnsignedShort()];
        for (int i = 0; i < this.chat.length; ++i) {
            this.chat[i] = this.readChatComponent(data);
        }
    }

    @Override
    public void doStuffServer(ChannelHandlerContext ctx) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doStuffClient() {
        PacketTempChatMultiline.addChat(this.chat);
    }

    private static synchronized void addChat(IChatComponent[] chat) {
        int i;
        GuiNewChat chatGUI = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        for (i = 0; i < chat.length; ++i) {
            IChatComponent iChatComponent = chat[i];
            chatGUI.func_146234_a(iChatComponent, 983423323 + i);
        }
        for (i = chat.length; i < lastNum; ++i) {
            chatGUI.func_146242_c(983423323 + i);
        }
        lastNum = Math.max(lastNum, chat.length);
    }

    @Override
    public boolean isValidSenderSide(Side properSenderSide) {
        return properSenderSide == Side.SERVER;
    }

    public static void addChatComponentMessage(IChatComponent chatComponentText) {
        chatComponents.get().add(chatComponentText);
    }

    public static void sendCached(EntityPlayer player) {
        List<IChatComponent> componentList = chatComponents.get();
        if (componentList.isEmpty()) {
            return;
        }
        if (!XUHelper.isPlayerFake(player)) {
            IChatComponent[] iChatComponents = componentList.toArray(new IChatComponent[componentList.size()]);
            if (player.field_70170_p.field_72995_K) {
                PacketTempChatMultiline.addChat(iChatComponents);
            } else {
                NetworkHandler.sendPacketToPlayer(new PacketTempChatMultiline(iChatComponents), player);
            }
        }
        componentList.clear();
    }
}

