/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.endercollector;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.block.BlockMultiBlock;
import com.rwtema.extrautils.block.BoxModel;
import com.rwtema.extrautils.tileentity.endercollector.TileEnderCollector;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockEnderCollector
extends BlockMultiBlock {
    IIcon side;
    IIcon bottom;
    IIcon top1;
    IIcon top2;
    IIcon side_disabled;
    IIcon top2_disabled;

    public BlockEnderCollector() {
        super(Material.field_151576_e);
        this.func_149663_c("extrautils:enderCollector");
        this.func_149647_a(ExtraUtils.creativeTabExtraUtils);
        this.func_149711_c(1.5f).func_149672_a(field_149769_e);
    }

    @Override
    public void prepareForRender(String label) {
    }

    @Override
    public BoxModel getWorldModel(IBlockAccess world, int x, int y, int z) {
        return this.getInventoryModel(world.func_72805_g(x, y, z));
    }

    @Override
    public BoxModel getInventoryModel(int metadata) {
        boolean disabled = metadata >= 6;
        BoxModel boxes = new BoxModel();
        IIcon sideIcon = disabled ? this.side_disabled : this.side;
        boxes.addBoxI(1, 0, 4, 15, 2, 12).setTexture(sideIcon).setTextureSides(this.bottom, this.top1);
        boxes.addBoxI(4, 0, 1, 12, 2, 15).setTexture(sideIcon).setTextureSides(this.bottom, this.top1);
        boxes.addBoxI(4, 2, 4, 12, 4, 12).setTexture(sideIcon).setTextureSides(this.bottom, this.top1);
        boxes.addBoxI(5, 4, 5, 11, 6, 11).setTexture(sideIcon).setTextureSides(this.bottom, this.top1);
        boxes.addBoxI(6, 6, 6, 10, 16, 10).setTexture(sideIcon).setTextureSides(this.bottom, this.top1);
        IIcon top2Icon = disabled ? this.top2_disabled : this.top2;
        boxes.addBoxI(6, 10, 1, 10, 14, 15).setTexture(sideIcon).setTextureSides(top2Icon, top2Icon);
        boxes.addBoxI(1, 10, 6, 15, 14, 10).setTexture(sideIcon).setTextureSides(top2Icon, top2Icon);
        boxes.rotateToSideTex(ForgeDirection.getOrientation((int)(metadata % 6)));
        return boxes;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEnderCollector) {
            ((TileEnderCollector)tileEntity).onNeighbourChange();
        }
    }

    public void func_149651_a(IIconRegister register) {
        this.side = register.func_94245_a("extrautils:enderCollectorSide");
        this.side_disabled = register.func_94245_a("extrautils:enderCollectorSide_disabled");
        this.field_149761_L = this.bottom = register.func_94245_a("extrautils:enderCollectorBottom");
        this.top1 = register.func_94245_a("extrautils:enderCollectorTop1");
        this.top2 = register.func_94245_a("extrautils:enderCollectorTop2");
        this.top2_disabled = register.func_94245_a("extrautils:enderCollectorTop2_disabled");
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEnderCollector();
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float p_149660_6_, float p_149660_7_, float p_149660_8_, int meta) {
        return side ^ 1;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEnderCollector) {
            return ((TileEnderCollector)tileEntity).onBlockActivated(world, x, y, z, player, side, hitX, hitY, hitZ);
        }
        return super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public void func_149749_a(World world, int x, int y, int z, Block p_149749_5_, int p_149749_6_) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEnderCollector) {
            ((TileEnderCollector)tileEntity).dropItems();
        }
        super.func_149749_a(world, x, y, z, p_149749_5_, p_149749_6_);
    }
}

