/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.auxiliary;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import org.apache.logging.log4j.Level;

public final class LogHelper {
    private ArrayList<String> _mReportedCategories = new ArrayList();
    private boolean doDebugLogs = false;
    private String _mModID = "";

    public LogHelper(String pModID) {
        this._mModID = pModID;
    }

    public void setDebugOutput(boolean pEnabled) {
        this.doDebugLogs = pEnabled;
    }

    public void ResetCategories() {
        this._mReportedCategories = new ArrayList();
    }

    public void log(String pCategory, Level pLogLevel, Object pObject) {
        if (pLogLevel == Level.DEBUG && !this.doDebugLogs) {
            return;
        }
        if (this._mReportedCategories.contains(pCategory)) {
            return;
        }
        this._mReportedCategories.add(pCategory);
        FMLLog.log((String)(this._mModID.toUpperCase() + " OTM"), (Level)pLogLevel, (String)String.valueOf(pObject), (Object[])new Object[0]);
    }

    public void log(Level pLogLevel, Object pObject) {
        if (pLogLevel == Level.DEBUG && !this.doDebugLogs) {
            return;
        }
        FMLLog.log((String)this._mModID.toUpperCase(), (Level)pLogLevel, (String)String.valueOf(pObject), (Object[])new Object[0]);
    }

    public void all(String pCategory, Object object) {
        this.log(pCategory, Level.ALL, object);
    }

    public void debug(String pCategory, Object object) {
        this.log(pCategory, Level.DEBUG, object);
    }

    public void error(String pCategory, Object object) {
        this.log(pCategory, Level.ERROR, object);
    }

    public void fatal(String pCategory, Object object) {
        this.log(pCategory, Level.FATAL, object);
    }

    public void info(String pCategory, Object object) {
        this.log(pCategory, Level.INFO, object);
    }

    public void off(String pCategory, Object object) {
        this.log(pCategory, Level.OFF, object);
    }

    public void trace(String pCategory, Object object) {
        this.log(pCategory, Level.TRACE, object);
    }

    public void warn(String pCategory, Object object) {
        this.log(pCategory, Level.WARN, object);
    }

    public void all(Object object) {
        this.log(Level.ALL, object);
    }

    public void debug(Object object) {
        this.log(Level.DEBUG, object);
    }

    public void error(Object object) {
        this.log(Level.ERROR, object);
    }

    public void fatal(Object object) {
        this.log(Level.FATAL, object);
    }

    public void info(Object object) {
        this.log(Level.INFO, object);
    }

    public void off(Object object) {
        this.log(Level.OFF, object);
    }

    public void trace(Object object) {
        this.log(Level.TRACE, object);
    }

    public void warn(Object object) {
        this.log(Level.WARN, object);
    }

    public void DumpStack(Exception e) {
        if (e.getMessage() != null) {
            FMLLog.severe((String)e.getMessage(), (Object[])new Object[0]);
        } else {
            FMLLog.severe((String)e.getStackTrace().toString(), (Object[])new Object[0]);
        }
    }

    public void DumpStack(String pCategory, Exception e) {
        if (this._mReportedCategories.contains(pCategory)) {
            return;
        }
        this._mReportedCategories.add(pCategory);
        this.DumpStack(e);
    }
}

