/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.auxiliary;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class Placeable<T>
implements Supplier<T> {
    @Nullable
    protected T value;

    public static <T> Placeable<T> make() {
        return new Placeable<T>();
    }

    @Override
    public T get() {
        if (this.value == null) {
            throw new IllegalStateException("Value hasn't been loaded yet.");
        }
        return this.value;
    }

    public void place(T value) {
        if (this.value != null) {
            throw new IllegalStateException("Value has been already loaded!");
        }
        this.value = value;
    }

    public boolean isLoaded() {
        return this.value != null;
    }

    public void ifLoaded(Consumer<? super T> consumer) {
        if (this.isLoaded()) {
            consumer.accept(this.get());
        }
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isLoaded()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.get()));
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isLoaded()) {
            return Optional.empty();
        }
        return Objects.requireNonNull(mapper.apply(this.get()));
    }

    public <U> Supplier<U> lazyMap(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return () -> this.isLoaded() ? mapper.apply((T)this.get()) : null;
    }

    public T orElse(T other) {
        return this.isLoaded() ? this.get() : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.isLoaded() ? this.get() : other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isLoaded()) {
            return this.get();
        }
        throw (Throwable)exceptionSupplier.get();
    }
}

