/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.datasource;

import eu.usrv.yamcore.auxiliary.LogHelper;
import eu.usrv.yamcore.datasource.Schema;
import eu.usrv.yamcore.datasource.bridge.BridgeMySQL;
import eu.usrv.yamcore.datasource.bridge.BridgeSQL;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class DatasourceSQL {
    protected LogHelper _mLog;
    protected String prefix = "";
    protected BridgeMySQL bridge;
    protected Schema _mSchema;

    public DatasourceSQL(LogHelper pLogger, Schema pSchema, String pHost, String pDBUser, String pDBPasswd, String pDBName) {
        this._mLog = pLogger;
        this._mSchema = pSchema;
        this.bridge = new BridgeMySQL(pHost, pDBUser, pDBPasswd, pDBName);
        this._mSchema.initializeUpdates(this.bridge);
        try {
            this.doUpdates();
        }
        catch (SQLException ex) {
            this._mLog.error("Failed to run database updates!");
            this._mLog.error(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        this.loadAll();
        this.checkAll();
    }

    public abstract boolean loadAll();

    public abstract boolean checkAll();

    public boolean stop() {
        try {
            this.bridge.getConnection().close();
            return true;
        }
        catch (SQLException e) {
            this._mLog.error("Failed to close connection to database.");
            this._mLog.error(ExceptionUtils.getStackTrace((Throwable)e));
            return false;
        }
    }

    protected boolean hasTable(String tableName) {
        try {
            DatabaseMetaData meta = this.bridge.getConnection().getMetaData();
            ResultSet rs = meta.getTables(null, null, this.prefix + tableName, null);
            return rs.next();
        }
        catch (Exception ex) {
            this._mLog.error("Failed to check for table existence.");
            this._mLog.error(ExceptionUtils.getStackTrace((Throwable)ex));
            return false;
        }
    }

    protected PreparedStatement prepare(String sql, boolean returnGenerationKeys) {
        try {
            return this.bridge.getConnection().prepareStatement(sql, returnGenerationKeys ? 1 : 2);
        }
        catch (SQLException e) {
            this._mLog.fatal(sql);
            this._mLog.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    protected void doUpdates() throws SQLException {
        PreparedStatement statement;
        ArrayList<String> ids = new ArrayList<String>();
        if (this.hasTable("Updates")) {
            statement = this.prepare("SELECT id FROM " + this.prefix + "Updates", false);
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                ids.add(rs.getString("id"));
            }
        }
        for (Schema.DBUpdate update : this._mSchema.updates) {
            if (ids.contains(update.id)) continue;
            try {
                this._mLog.info(String.format("Running update %s - %s", update.id, update.desc));
                statement = this.prepare(update.statement, false);
                statement.execute();
                statement = this.prepare("INSERT INTO " + this.prefix + "Updates (id,description) VALUES(?,?)", true);
                statement.setString(1, update.id);
                statement.setString(2, update.desc);
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this._mLog.error(String.format("Update (%s - %s) failed to apply!", update.id, update.desc));
                this._mLog.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
        }
    }

    public BridgeSQL getBridge() {
        return this.bridge;
    }
}

