/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.forge;

import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ListItemHandler
implements IItemHandlerModifiable {
    protected final Iterable<? extends IItemHandlerModifiable> listItemHandler;

    public ListItemHandler(Iterable<? extends IItemHandlerModifiable> listItemHandler) {
        this.listItemHandler = listItemHandler;
    }

    @Override
    public int getSlots() {
        int ret = 0;
        for (IItemHandlerModifiable iItemHandlerModifiable : this.listItemHandler) {
            ret += iItemHandlerModifiable.getSlots();
        }
        return ret;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        Pair<? extends IItemHandlerModifiable, Integer> result = this.findItemHandler(slot);
        return ((IItemHandlerModifiable)result.getLeft()).getStackInSlot((Integer)result.getRight());
    }

    @Override
    @Nullable
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        Pair<? extends IItemHandlerModifiable, Integer> result = this.findItemHandler(slot);
        return ((IItemHandlerModifiable)result.getLeft()).insertItem((Integer)result.getRight(), stack, simulate);
    }

    @Override
    @Nullable
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        Pair<? extends IItemHandlerModifiable, Integer> result = this.findItemHandler(slot);
        return ((IItemHandlerModifiable)result.getLeft()).extractItem((Integer)result.getRight(), amount, simulate);
    }

    @Override
    public int getSlotLimit(int slot) {
        Pair<? extends IItemHandlerModifiable, Integer> result = this.findItemHandler(slot);
        return ((IItemHandlerModifiable)result.getLeft()).getSlotLimit((Integer)result.getRight());
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        Pair<? extends IItemHandlerModifiable, Integer> result = this.findItemHandler(slot);
        ((IItemHandlerModifiable)result.getLeft()).setStackInSlot((Integer)result.getRight(), stack);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        Pair<? extends IItemHandlerModifiable, Integer> result = this.findItemHandler(slot);
        return ((IItemHandlerModifiable)result.getLeft()).isItemValid((Integer)result.getRight(), stack);
    }

    protected Pair<? extends IItemHandlerModifiable, Integer> findItemHandler(int slot) {
        int searching = 0;
        for (IItemHandlerModifiable iItemHandlerModifiable : this.listItemHandler) {
            int numSlots = iItemHandlerModifiable.getSlots();
            if (slot >= searching && slot < searching + numSlots) {
                return new ImmutablePair((Object)iItemHandlerModifiable, (Object)(slot - searching));
            }
            searching += numSlots;
        }
        throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
    }
}

