/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks.tiles;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import makeo.gadomancy.common.blocks.tiles.TileManipulatorPillar;
import makeo.gadomancy.common.network.PacketHandler;
import makeo.gadomancy.common.network.packets.PacketStartAnimation;
import makeo.gadomancy.common.network.packets.PacketTCNodeBolt;
import makeo.gadomancy.common.network.packets.PacketTCWispyLine;
import makeo.gadomancy.common.node.NodeManipulatorResult;
import makeo.gadomancy.common.node.NodeManipulatorResultHandler;
import makeo.gadomancy.common.registration.RegisteredBlocks;
import makeo.gadomancy.common.registration.RegisteredMultiblocks;
import makeo.gadomancy.common.registration.RegisteredRecipes;
import makeo.gadomancy.common.utils.MultiblockHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.wands.IWandable;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.TilePedestal;
import thaumcraft.common.tiles.TileWandPedestal;

public class TileNodeManipulator
extends TileWandPedestal
implements IWandable {
    private static final int NODE_MANIPULATION_POSSIBLE_WORK_START = 70;
    private static final int NODE_MANIPULATION_WORK_ASPECT_CAP = 120;
    private static final int ELDRITCH_PORTAL_CREATOR_WORK_START = 120;
    private static final int ELDRITCH_PORTAL_CREATOR_ASPECT_CAP = 150;
    private MultiblockType multiblockType;
    private boolean multiblockStructurePresent;
    private boolean isMultiblock;
    private AspectList workAspectList = new AspectList();
    private List<ChunkCoordinates> bufferedCCPedestals = new ArrayList<ChunkCoordinates>();
    private boolean isWorking;
    private int workTick;

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isInMultiblock()) {
            this.checkMultiblockTick();
        }
        if (this.isInMultiblock()) {
            this.multiblockTick();
        }
    }

    private void multiblockTick() {
        if (this.multiblockType == null) {
            if (MultiblockHelper.isMultiblockPresent(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, RegisteredMultiblocks.completeNodeManipulatorMultiblock)) {
                this.multiblockType = MultiblockType.NODE_MANIPULATOR;
            } else if (MultiblockHelper.isMultiblockPresent(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, RegisteredMultiblocks.completeEldritchPortalCreator) && this.checkEldritchEyes(false)) {
                this.multiblockType = MultiblockType.E_PORTAL_CREATOR;
            }
        }
        if (this.multiblockType == null) {
            this.breakMultiblock();
            return;
        }
        switch (this.multiblockType) {
            case NODE_MANIPULATOR: {
                if (!this.isWorking) {
                    this.doAspectChecks(120, 70);
                    break;
                }
                this.manipulationTick();
                break;
            }
            case E_PORTAL_CREATOR: {
                if (!this.isWorking) {
                    this.doAspectChecks(150, 120);
                    break;
                }
                if (!this.checkEldritchEyes(true)) {
                    if (this.workTick > 1) {
                        this.workAspectList = new AspectList();
                        this.workTick = 0;
                        this.isWorking = false;
                        this.func_70296_d();
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    return;
                }
                this.eldritchPortalCreationTick();
            }
        }
    }

    private boolean checkEldritchEyes(boolean checkForEyes) {
        this.bufferedCCPedestals.clear();
        int validPedestalsFound = 0;
        block0: for (int xDiff = -8; xDiff <= 8; ++xDiff) {
            block1: for (int zDiff = -8; zDiff <= 8; ++zDiff) {
                for (int yDiff = -5; yDiff <= 10; ++yDiff) {
                    int itX = this.field_145851_c + xDiff;
                    int itY = this.field_145848_d + yDiff;
                    int itZ = this.field_145849_e + zDiff;
                    Block block = this.field_145850_b.func_147439_a(itX, itY, itZ);
                    int meta = this.field_145850_b.func_72805_g(itX, itY, itZ);
                    TileEntity te = this.field_145850_b.func_147438_o(itX, itY, itZ);
                    if (block == null || !block.equals((Object)RegisteredBlocks.blockStoneMachine) || meta != 1 || te == null || !(te instanceof TilePedestal) || checkForEyes && !this.checkTile((TilePedestal)te)) continue;
                    this.bufferedCCPedestals.add(new ChunkCoordinates(itX, itY, itZ));
                    if (++validPedestalsFound < 4) continue block1;
                    break block0;
                }
            }
        }
        return validPedestalsFound >= 4;
    }

    private boolean checkTile(TilePedestal te) {
        ItemStack stack = te.func_70301_a(0);
        return stack != null && stack.func_77973_b() == ConfigItems.itemEldritchObject && stack.func_77960_j() == 0;
    }

    private void eldritchPortalCreationTick() {
        ++this.workTick;
        if (this.workTick < 400) {
            PacketTCNodeBolt bolt;
            if ((this.workTick & 0xF) == 0) {
                PacketStartAnimation packet = new PacketStartAnimation(3, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)packet, this.getTargetPoint(32.0));
            }
            if ((this.workTick & 7) == 0) {
                int index = this.workTick >> 3 & 3;
                try {
                    ChunkCoordinates cc = this.bufferedCCPedestals.get(index);
                    PacketStartAnimation packet = new PacketStartAnimation(3, cc.field_71574_a, cc.field_71572_b, cc.field_71573_c, 1);
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)packet, this.getTargetPoint(32.0));
                }
                catch (Exception cc) {
                    // empty catch block
                }
            }
            if (this.field_145850_b.field_73012_v.nextBoolean()) {
                Vec3 rel = this.getRelPillarLoc(this.field_145850_b.field_73012_v.nextInt(4));
                bolt = new PacketTCNodeBolt((float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 2.5f, (float)this.field_145849_e + 0.5f, (float)((double)((float)this.field_145851_c + 0.5f) + rel.field_72450_a), (float)((double)((float)this.field_145848_d + 2.5f) + rel.field_72448_b), (float)((double)((float)this.field_145849_e + 0.5f) + rel.field_72449_c), 2, false);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)bolt, this.getTargetPoint(32.0));
            }
            if (this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                Vec3 relPed = this.getRelPedestalLoc(this.field_145850_b.field_73012_v.nextInt(4));
                bolt = new PacketTCNodeBolt((float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 2.5f, (float)this.field_145849_e + 0.5f, (float)((double)((float)this.field_145851_c + 0.5f) - relPed.field_72450_a), (float)((double)this.field_145848_d + 1.5 + relPed.field_72448_b), (float)((double)((float)this.field_145849_e + 0.5f) - relPed.field_72449_c), 2, false);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)bolt, this.getTargetPoint(32.0));
            }
        } else {
            this.schedulePortalCreation();
        }
    }

    private void schedulePortalCreation() {
        this.workTick = 0;
        this.isWorking = false;
        this.workAspectList = new AspectList();
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e);
        if (te == null || !(te instanceof INode)) {
            return;
        }
        this.consumeEldritchEyes();
        this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e);
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e, (Block)RegisteredBlocks.blockAdditionalEldrichPortal);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e);
        this.func_70296_d();
    }

    private void consumeEldritchEyes() {
        for (ChunkCoordinates cc : this.bufferedCCPedestals) {
            try {
                TilePedestal pedestal = (TilePedestal)this.field_145850_b.func_147438_o(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
                pedestal.func_70299_a(0, null);
                PacketStartAnimation packet = new PacketStartAnimation(4, cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)packet, this.getTargetPoint(32.0));
            }
            catch (Exception exception) {}
        }
    }

    private void manipulationTick() {
        ++this.workTick;
        if (this.workTick < 300) {
            if (this.workTick % 16 == 0) {
                PacketStartAnimation packet = new PacketStartAnimation(3, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)packet, this.getTargetPoint(32.0));
            }
            if (this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                Vec3 rel = this.getRelPillarLoc(this.field_145850_b.field_73012_v.nextInt(4));
                PacketTCNodeBolt bolt = new PacketTCNodeBolt((float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 2.5f, (float)this.field_145849_e + 0.5f, (float)((double)((float)this.field_145851_c + 0.5f) + rel.field_72450_a), (float)((double)((float)this.field_145848_d + 2.5f) + rel.field_72448_b), (float)((double)((float)this.field_145849_e + 0.5f) + rel.field_72449_c), 0, false);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)bolt, this.getTargetPoint(32.0));
            }
        } else {
            this.scheduleManipulation();
        }
    }

    private Vec3 getRelPedestalLoc(int pedestalId) {
        try {
            ChunkCoordinates cc = this.bufferedCCPedestals.get(pedestalId);
            return Vec3.func_72443_a((double)(this.field_145851_c - cc.field_71574_a), (double)(this.field_145848_d - cc.field_71572_b), (double)(this.field_145849_e - cc.field_71573_c));
        }
        catch (Exception exception) {
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
    }

    private Vec3 getRelPillarLoc(int pillarId) {
        switch (pillarId) {
            case 0: {
                return Vec3.func_72443_a((double)0.7, (double)-0.6, (double)0.7);
            }
            case 1: {
                return Vec3.func_72443_a((double)-0.7, (double)-0.6, (double)0.7);
            }
            case 2: {
                return Vec3.func_72443_a((double)-0.7, (double)-0.6, (double)-0.7);
            }
            case 3: {
                return Vec3.func_72443_a((double)0.7, (double)-0.6, (double)-0.7);
            }
        }
        return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    }

    private void scheduleManipulation() {
        NodeManipulatorResult result;
        float overSized = this.calcOversize(70);
        this.workTick = 0;
        this.isWorking = false;
        this.workAspectList = new AspectList();
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e);
        if (te == null || !(te instanceof INode)) {
            return;
        }
        INode node = (INode)te;
        int areaRange = 50;
        int percChanceForBetter = 0;
        if (areaRange > 0) {
            percChanceForBetter = (int)(overSized / (float)areaRange * 100.0f);
        }
        while (!(result = NodeManipulatorResultHandler.getRandomResult(this.field_145850_b, node, percChanceForBetter)).affect(this.field_145850_b, node)) {
        }
        PacketStartAnimation packet = new PacketStartAnimation(4, this.field_145851_c, this.field_145848_d + 2, this.field_145849_e);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)packet, this.getTargetPoint(32.0));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e);
        this.func_70296_d();
        ((TileEntity)node).func_70296_d();
    }

    private float calcOversize(int neededAspects) {
        int overall = 0;
        for (Aspect a : Aspect.getPrimalAspects()) {
            overall += this.workAspectList.getAmount(a) - neededAspects;
        }
        return (float)overall / 6.0f;
    }

    private void doAspectChecks(int aspectCap, int possibleWorkStart) {
        if (this.canDrainFromWand(aspectCap)) {
            Aspect a = this.drainAspectFromWand(aspectCap);
            if (a != null) {
                this.playAspectDrainFromWand(a);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_70296_d();
            }
        } else {
            this.checkIfEnoughVis(possibleWorkStart);
        }
    }

    private void checkIfEnoughVis(int start) {
        boolean enough = true;
        for (Aspect a : Aspect.getPrimalAspects()) {
            if (this.workAspectList.getAmount(a) >= start) continue;
            enough = false;
            break;
        }
        if (enough) {
            this.isWorking = true;
        }
    }

    private Aspect drainAspectFromWand(int cap) {
        ItemStack stack = this.func_70301_a(0);
        if (stack == null || !(stack.func_77973_b() instanceof ItemWandCasting)) {
            return null;
        }
        AspectList aspects = ((ItemWandCasting)stack.func_77973_b()).getAllVis(stack);
        for (Aspect a : this.getRandomlyOrderedPrimalAspectList()) {
            if (aspects.getAmount(a) < 100 || this.workAspectList.getAmount(a) >= cap) continue;
            int amt = aspects.getAmount(a);
            ((ItemWandCasting)stack.func_77973_b()).storeVis(stack, a, amt - 100);
            this.workAspectList.add(a, 1);
            return a;
        }
        return null;
    }

    private List<Aspect> getRandomlyOrderedPrimalAspectList() {
        ArrayList primals = (ArrayList)Aspect.getPrimalAspects().clone();
        Collections.shuffle(primals);
        return primals;
    }

    private boolean canDrainFromWand(int cap) {
        ItemStack stack = this.func_70301_a(0);
        if (stack == null || !(stack.func_77973_b() instanceof ItemWandCasting)) {
            return false;
        }
        AspectList aspects = ((ItemWandCasting)stack.func_77973_b()).getAllVis(stack);
        for (Aspect a : Aspect.getPrimalAspects()) {
            if (aspects.getAmount(a) < 100 || this.workAspectList.getAmount(a) >= cap) continue;
            return true;
        }
        return false;
    }

    private void checkMultiblockTick() {
        this.checkMultiblock();
        if (!this.isMultiblockStructurePresent()) {
            this.breakMultiblock();
            this.isMultiblock = false;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    private void playAspectDrainFromWand(Aspect drained) {
        if (drained == null) {
            return;
        }
        NetworkRegistry.TargetPoint point = this.getTargetPoint(32.0);
        PacketTCWispyLine line = new PacketTCWispyLine(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.8, (double)this.field_145849_e + 0.5, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.4 + (double)this.field_145850_b.field_73012_v.nextInt(4) / 10.0, (double)this.field_145849_e + 0.5, 40, drained.getColor());
        PacketHandler.INSTANCE.sendToAllAround((IMessage)line, point);
    }

    private void dropWand() {
        if (this.func_70301_a(0) != null) {
            InventoryUtils.dropItems((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }
    }

    public void breakMultiblock() {
        MultiblockHelper.MultiblockPattern toRestore;
        MultiblockHelper.MultiblockPattern compareableCompleteStructure;
        if (this.multiblockType == null) {
            this.workAspectList = new AspectList();
            this.dropWand();
            this.workTick = 0;
            this.isWorking = false;
            return;
        }
        switch (this.multiblockType) {
            case NODE_MANIPULATOR: {
                compareableCompleteStructure = RegisteredMultiblocks.completeNodeManipulatorMultiblock;
                toRestore = RegisteredMultiblocks.incompleteNodeManipulatorMultiblock;
                break;
            }
            case E_PORTAL_CREATOR: {
                compareableCompleteStructure = RegisteredMultiblocks.completeEldritchPortalCreator;
                toRestore = RegisteredMultiblocks.incompleteEldritchPortalCreator;
                break;
            }
            default: {
                return;
            }
        }
        for (MultiblockHelper.IntVec3 v : compareableCompleteStructure.keySet()) {
            int absZ;
            int absY;
            int absX;
            MultiblockHelper.BlockInfo info = (MultiblockHelper.BlockInfo)compareableCompleteStructure.get(v);
            MultiblockHelper.BlockInfo restoreInfo = (MultiblockHelper.BlockInfo)toRestore.get(v);
            if (info.block == RegisteredBlocks.blockNode || info.block == RegisteredBlocks.blockStoneMachine && (info.meta == 0 || info.meta == 3) || info.block == Blocks.field_150350_a || info.block == RegisteredBlocks.blockNodeManipulator || this.field_145850_b.func_147439_a(absX = v.x + this.field_145851_c, absY = v.y + this.field_145848_d, absZ = v.z + this.field_145849_e) != info.block || this.field_145850_b.func_72805_g(absX, absY, absZ) != info.meta) continue;
            this.field_145850_b.func_147465_d(absX, absY, absZ, Blocks.field_150350_a, 0, 0);
            this.field_145850_b.func_147465_d(absX, absY, absZ, restoreInfo.block, restoreInfo.meta, 0);
            this.field_145850_b.func_147471_g(absX, absY, absZ);
        }
        this.workAspectList = new AspectList();
        this.multiblockType = null;
        this.dropWand();
        this.workTick = 0;
        this.isWorking = false;
    }

    public void formMultiblock() {
        MultiblockHelper.MultiblockPattern toBuild;
        if (this.multiblockType == null) {
            return;
        }
        switch (this.multiblockType) {
            case NODE_MANIPULATOR: {
                toBuild = RegisteredMultiblocks.completeNodeManipulatorMultiblock;
                break;
            }
            case E_PORTAL_CREATOR: {
                toBuild = RegisteredMultiblocks.completeEldritchPortalCreator;
                break;
            }
            default: {
                return;
            }
        }
        for (MultiblockHelper.IntVec3 v : toBuild.keySet()) {
            MultiblockHelper.BlockInfo info = (MultiblockHelper.BlockInfo)toBuild.get(v);
            if (info.block == RegisteredBlocks.blockNode || info.block == RegisteredBlocks.blockStoneMachine && (info.meta == 0 || info.meta == 1 || info.meta == 3) || info.block == Blocks.field_150350_a || info.block == RegisteredBlocks.blockNodeManipulator) continue;
            int absX = v.x + this.field_145851_c;
            int absY = v.y + this.field_145848_d;
            int absZ = v.z + this.field_145849_e;
            this.field_145850_b.func_147465_d(absX, absY, absZ, Blocks.field_150350_a, 0, 0);
            this.field_145850_b.func_147465_d(absX, absY, absZ, info.block, info.meta, 0);
            this.field_145850_b.func_147471_g(absX, absY, absZ);
        }
        NetworkRegistry.TargetPoint target = this.getTargetPoint(32.0);
        TileManipulatorPillar pillar = (TileManipulatorPillar)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 1);
        pillar.setOrientation((byte)5);
        PacketStartAnimation animation = new PacketStartAnimation(3, pillar.field_145851_c, pillar.field_145848_d, pillar.field_145849_e);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)animation, target);
        TileManipulatorPillar pillar2 = (TileManipulatorPillar)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 1);
        pillar2.setOrientation((byte)3);
        animation = new PacketStartAnimation(3, pillar2.field_145851_c, pillar2.field_145848_d, pillar2.field_145849_e);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)animation, target);
        TileManipulatorPillar pillar3 = (TileManipulatorPillar)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 1);
        pillar3.setOrientation((byte)4);
        animation = new PacketStartAnimation(3, pillar3.field_145851_c, pillar3.field_145848_d, pillar3.field_145849_e);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)animation, target);
        animation = new PacketStartAnimation(3, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 1);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)animation, target);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
        this.isMultiblock = true;
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        NBTTagCompound tag = compound.func_74775_l("Gadomancy");
        this.multiblockStructurePresent = tag.func_74767_n("mBlockPresent");
        this.isMultiblock = tag.func_74767_n("mBlockState");
        this.isWorking = tag.func_74767_n("manipulating");
        this.workTick = tag.func_74762_e("workTick");
        if (tag.func_74764_b("multiblockType")) {
            this.multiblockType = MultiblockType.values()[tag.func_74762_e("multiblockType")];
        }
        this.workAspectList.readFromNBT(tag, "workAspectList");
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("mBlockPresent", this.multiblockStructurePresent);
        tag.func_74757_a("mBlockState", this.isMultiblock);
        tag.func_74757_a("manipulating", this.isWorking);
        tag.func_74768_a("workTick", this.workTick);
        if (this.multiblockType != null) {
            tag.func_74768_a("multiblockType", this.multiblockType.ordinal());
        }
        this.workAspectList.writeToNBT(tag, "workAspectList");
        compound.func_74782_a("Gadomancy", (NBTBase)tag);
    }

    public boolean isInMultiblock() {
        return this.isMultiblock;
    }

    public boolean isMultiblockStructurePresent() {
        return this.multiblockStructurePresent;
    }

    public MultiblockType getMultiblockType() {
        return this.multiblockType;
    }

    public boolean checkMultiblock() {
        boolean prevState = this.isMultiblockStructurePresent();
        if (prevState) {
            if (this.isInMultiblock()) {
                if (this.multiblockType == null) {
                    if (MultiblockHelper.isMultiblockPresent(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, RegisteredMultiblocks.completeNodeManipulatorMultiblock)) {
                        this.multiblockType = MultiblockType.NODE_MANIPULATOR;
                    } else if (MultiblockHelper.isMultiblockPresent(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, RegisteredMultiblocks.completeEldritchPortalCreator) && this.checkEldritchEyes(false)) {
                        this.multiblockType = MultiblockType.E_PORTAL_CREATOR;
                    }
                }
                if (this.multiblockType == null) {
                    this.breakMultiblock();
                    return false;
                }
                switch (this.multiblockType) {
                    case NODE_MANIPULATOR: {
                        this.setMultiblockStructurePresent(MultiblockHelper.isMultiblockPresent(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, RegisteredMultiblocks.completeNodeManipulatorMultiblock), MultiblockType.NODE_MANIPULATOR);
                        break;
                    }
                    case E_PORTAL_CREATOR: {
                        this.setMultiblockStructurePresent(MultiblockHelper.isMultiblockPresent(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, RegisteredMultiblocks.completeEldritchPortalCreator) && this.checkEldritchEyes(false), MultiblockType.E_PORTAL_CREATOR);
                    }
                }
            } else {
                this.checkForNonExistingMultiblock();
            }
        } else {
            this.checkForNonExistingMultiblock();
        }
        return this.isMultiblockStructurePresent();
    }

    private void setMultiblockStructurePresent(boolean present, MultiblockType type) {
        if (present) {
            this.multiblockType = type;
        }
        this.multiblockStructurePresent = present;
    }

    private void checkForNonExistingMultiblock() {
        HashMap<MultiblockHelper.MultiblockPattern, MultiblockType> patternMap = new HashMap<MultiblockHelper.MultiblockPattern, MultiblockType>();
        patternMap.put(RegisteredMultiblocks.incompleteEldritchPortalCreator, MultiblockType.E_PORTAL_CREATOR);
        patternMap.put(RegisteredMultiblocks.incompleteNodeManipulatorMultiblock, MultiblockType.NODE_MANIPULATOR);
        for (MultiblockHelper.MultiblockPattern pattern : patternMap.keySet()) {
            if (!MultiblockHelper.isMultiblockPresent(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, pattern)) continue;
            if (pattern == RegisteredMultiblocks.incompleteEldritchPortalCreator && !this.checkEldritchEyes(false)) {
                return;
            }
            this.setMultiblockStructurePresent(true, (MultiblockType)((Object)patternMap.get(pattern)));
            return;
        }
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.isInMultiblock() && super.func_102007_a(par1, par2ItemStack, par3);
    }

    public NetworkRegistry.TargetPoint getTargetPoint(double radius) {
        return new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, radius);
    }

    public AspectList getAspects() {
        return this.workAspectList;
    }

    public void setAspects(AspectList aspectList) {
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return false;
    }

    public int addToContainer(Aspect aspect, int i) {
        return 0;
    }

    public boolean takeFromContainer(Aspect aspect, int i) {
        return false;
    }

    public boolean takeFromContainer(AspectList aspectList) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int i) {
        return false;
    }

    public boolean doesContainerContain(AspectList aspectList) {
        return false;
    }

    public int containerContains(Aspect aspect) {
        return 0;
    }

    public int onWandRightClick(World world, ItemStack stack, EntityPlayer player, int i, int i2, int i3, int i4, int i5) {
        return 0;
    }

    public ItemStack onWandRightClick(World world, ItemStack stack, EntityPlayer player) {
        return null;
    }

    public void onUsingWandTick(ItemStack stack, EntityPlayer player, int i) {
    }

    public void onWandStoppedUsing(ItemStack stack, World world, EntityPlayer player, int i) {
    }

    public static enum MultiblockType {
        NODE_MANIPULATOR("gadomancy".toUpperCase() + ".NODE_MANIPULATOR", RegisteredRecipes.costsNodeManipulatorMultiblock),
        E_PORTAL_CREATOR("gadomancy".toUpperCase() + ".E_PORTAL_CREATOR", RegisteredRecipes.costsEldritchPortalCreatorMultiblock);

        private String research;
        private AspectList costs;

        private MultiblockType(String research, AspectList costs) {
            this.research = research;
            this.costs = costs;
        }

        public String getResearchNeeded() {
            return this.research;
        }

        public AspectList getMultiblockCosts() {
            return this.costs;
        }
    }
}

