/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.registration;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.passive.EntitySheep;

public class AIShutdownWhitelist {
    private static Map<Class<? extends EntityLiving>, List<Class<? extends EntityAIBase>>> whitelistedAI = new HashMap<Class<? extends EntityLiving>, List<Class<? extends EntityAIBase>>>();

    private AIShutdownWhitelist() {
    }

    public static void whitelistAIClass(Class<? extends EntityLiving> entityClass, Class<? extends EntityAIBase> aiClass) {
        if (!whitelistedAI.containsKey(entityClass)) {
            whitelistedAI.put(entityClass, new LinkedList());
        }
        whitelistedAI.get(entityClass).add(aiClass);
    }

    public static void whitelistAIClass(EntityLiving entity, Class<? extends EntityAIBase> aiClass) {
        AIShutdownWhitelist.whitelistAIClass(entity.getClass(), aiClass);
    }

    public static List<Class<? extends EntityAIBase>> getWhitelistedAIClasses(EntityLiving entity) {
        if (!whitelistedAI.containsKey(entity.getClass())) {
            return Lists.newArrayList();
        }
        return whitelistedAI.get(entity.getClass());
    }

    static {
        AIShutdownWhitelist.whitelistAIClass(EntitySheep.class, EntityAIEatGrass.class);
    }
}

