/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.utils;

import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class MultiblockHelper {
    public static boolean isAnyMultiblockPresent(World world, int x, int y, int z, List<MultiblockPattern> patternList) {
        for (MultiblockPattern pattern : patternList) {
            if (!MultiblockHelper.isMultiblockPresent(world, x, y, z, pattern)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMultiblockPresent(World world, int x, int y, int z, MultiblockPattern pattern) {
        for (IntVec3 vec : pattern.keySet()) {
            BlockInfo expected = (BlockInfo)pattern.get(vec);
            Block realBlock = world.func_147439_a(x + vec.x, y + vec.y, z + vec.z);
            int realMeta = world.func_72805_g(x + vec.x, y + vec.y, z + vec.z);
            if (expected.block == realBlock && expected.meta == realMeta) continue;
            return false;
        }
        return true;
    }

    public static class MultiblockPattern
    extends LinkedHashMap<IntVec3, BlockInfo> {
        public MultiblockPattern(Block originBlock, int originMeta) {
            this.put(this.createIntVec3(0, 0, 0), new BlockInfo(originBlock, originMeta));
        }

        public MultiblockPattern addBlock(int relativeX, int relativeY, int relativeZ, Block expectedBlock, int expectedMeta) {
            this.put(this.createIntVec3(relativeX, relativeY, relativeZ), new BlockInfo(expectedBlock, expectedMeta));
            return this;
        }

        private IntVec3 createIntVec3(int x, int y, int z) {
            return new IntVec3(x, y, z);
        }
    }

    public static class IntVec3 {
        public int x;
        public int y;
        public int z;

        public IntVec3(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntVec3 intVec3 = (IntVec3)o;
            return this.x == intVec3.x && this.y == intVec3.y && this.z == intVec3.z;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.z;
            return result;
        }
    }

    public static class BlockInfo {
        public Block block;
        public int meta;

        private BlockInfo(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }
    }
}

