/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.TC;

import com.github.bartimaeusnek.cropspp.CCropUtility;
import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicTinkerBerryCrop;
import ic2.api.crops.ICropTile;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import thaumcraft.api.ItemApi;

public class MagicMetalBerryCrop
extends BasicTinkerBerryCrop {
    @Override
    public int tier() {
        return 7;
    }

    public String name() {
        return "Magic Metal Berry";
    }

    public String[] attributes() {
        return new String[]{"OreBerry", "Magic", "Metal", "Thaumium", "Void"};
    }

    @Override
    protected String hasBlock() {
        return "";
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        if (crop.getSize() >= this.maxSize()) {
            return false;
        }
        if (ConfigValues.debug) {
            return true;
        }
        if (crop.getSize() >= this.maxSize() - 1) {
            return crop.isBlockBelow("blockThaumium") || crop.isBlockBelow("blockThauminite") || crop.isBlockBelow("blockIron") || crop.isBlockBelow("blockVoid");
        }
        return crop.getLightLevel() <= 10;
    }

    public int growthDuration(ICropTile crop) {
        if (ConfigValues.debug) {
            return 1;
        }
        if (crop.getSize() >= this.maxSize() - 1) {
            return crop.isBlockBelow("blockThaumium") ? 1800 : 3300;
        }
        if (crop.getSize() >= this.maxSize() - 2) {
            return 1200;
        }
        return 500;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() >= this.maxSize();
    }

    public ItemStack getGain(ICropTile crop) {
        if (crop.isBlockBelow("blockThaumium") || crop.isBlockBelow("blockIron")) {
            return CCropUtility.getCopiedOreStack("nuggetThaumium");
        }
        if (crop.isBlockBelow("blockVoid")) {
            return CCropUtility.getCopiedOreStack("nuggetVoid");
        }
        if (crop.isBlockBelow("blockThauminite")) {
            return CCropUtility.getCopiedOreStack("nuggetThauminite");
        }
        return null;
    }

    @Override
    public List<String> getCropInformation() {
        return Arrays.asList("Needs a block of Thaumium, Iron, Thauminite or Void Below to fully mature.", "Drops the Magic-Metal that is underneath (Iron will drop Thaumium)", "Matures fastest with Thaumium under it.", "Needs a light level below or equal to 10 to fully mature.");
    }

    @Override
    public ItemStack getDisplayItem() {
        return ItemApi.getItem((String)"itemResource", (int)17);
    }
}

