/*
 * Decompiled with CFR 0.152.
 */
package baubles.common;

import baubles.api.expanded.BaubleExpandedSlots;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;

public class BaublesConfig {
    public static boolean hideDebugItem = true;
    public static int[] soulBoundEnchantments = new int[0];
    public static boolean useOldGuiButton = false;
    public static boolean useOldGuiRendering = false;
    public static boolean showUnusedSlots = false;
    public static boolean manualSlotSelection = false;
    public static String[] overrideSlotTypes = new String[]{"amulet", "ring", "ring", "belt"};
    static final String categoryDebug = "debug";
    static final String categoryGeneral = "general";
    static final String categoryMenu = "menu";
    static final String categoryClient = "client";
    static final String categoryOverride = "override";

    public static void loadConfig(Configuration config) {
        ArrayList<String> currentlyRegisteredTypes = BaubleExpandedSlots.getCurrentlyRegisteredTypes();
        String[] currentSlotAssignments = BaubleExpandedSlots.getCurrentSlotAssignments();
        hideDebugItem = config.getBoolean("hideDebugItem", categoryDebug, hideDebugItem, "Hides the Bauble debug item from the creative menu.\n");
        soulBoundEnchantments = config.get(categoryGeneral, "soulBoundEnchantments", soulBoundEnchantments, "IDs of enchantments that should be treated as soul bound when on items in a bauble slot.").getIntList();
        useOldGuiButton = config.getBoolean("useOldGuiButton", categoryClient, useOldGuiButton, "Use the old Baubles Button texture and location instead.\n");
        useOldGuiRendering = config.getBoolean("useOldRendering", categoryClient, useOldGuiRendering, "Display the old Bauble GUI instead of the new sidebar.\n");
        showUnusedSlots = config.getBoolean("showUnusedSlots", categoryMenu, showUnusedSlots, "Display unused Bauble slots.\n");
        manualSlotSelection = config.getBoolean("manualSlotSelection", categoryMenu, manualSlotSelection, "Manually override slot assignments.\n!Bauble slot types must be configured manually with this option enabled!\n");
        config.getStringList("defualtSlotTypes", categoryOverride, new String[0], "Baubles and its addons assigned the folowing types to the bauble slots.\n!This config option automatically changes to reflect what Baubles and its addons assigned each time the game is launched!");
        config.getCategory(categoryOverride).get("defualtSlotTypes").set(currentSlotAssignments);
        overrideSlotTypes = config.getStringList("slotTypeOverrides", categoryOverride, overrideSlotTypes, "Slot assignments to use if manualSlotSelection is enabled.\nAny assignments after the first 20 will be ignored.\n!Adding, moving, or removing slots of the amulet, ring, or belt types will reduce compatibility with mods made for original Baubles versions!\n", currentlyRegisteredTypes.toArray(new String[0]));
        if (manualSlotSelection) {
            BaubleExpandedSlots.overrideSlots(overrideSlotTypes);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }
}

