/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class URLClassLoaderBase
extends URLClassLoader {
    public URLClassLoaderBase(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public URLClassLoaderBase(URL[] urls) {
        super(urls);
    }

    public URLClassLoaderBase(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public URLClassLoaderBase(String name, URL[] urls, ClassLoader parent) {
        super(name, urls, parent);
    }

    public URLClassLoaderBase(String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(name, urls, parent, factory);
    }

    public static int implementationVersion() {
        return 9;
    }

    public String getClassLoaderName() {
        return super.getName();
    }

    public static ClassLoader getPlatformClassLoader() {
        return ClassLoader.getPlatformClassLoader();
    }

    public Package getDefinedPackageUniversal(String name) {
        return this.getDefinedPackage(name);
    }

    public static Package getDefinedPackageUniversalOf(ClassLoader loader, String name) {
        return loader.getDefinedPackage(name);
    }

    public static byte[] readAllBytes(InputStream stream, byte[] readBuffer) throws IOException {
        return stream.readAllBytes();
    }

    public Package getAndVerifyPackage(String packageName, Manifest manifest, URL codeSourceURL) {
        Package pkg = this.getDefinedPackage(packageName);
        if (pkg == null) {
            pkg = this.getClass().getClassLoader().getDefinedPackage(packageName);
        }
        if (pkg != null) {
            if (pkg.isSealed()) {
                if (!pkg.isSealed(codeSourceURL)) {
                    throw new SecurityException("Sealing violation in package " + packageName);
                }
            } else if (manifest != null && this.isSealed(packageName, manifest)) {
                throw new SecurityException("Sealing violation in already loaded package " + packageName);
            }
        } else {
            return this.definePackage(packageName, manifest != null ? manifest : new Manifest(), codeSourceURL);
        }
        return pkg;
    }

    public boolean isSealed(String packageName, Manifest manifest) {
        String value;
        String value2;
        if (manifest == null) {
            return false;
        }
        String path = packageName.replace('.', '/') + "/";
        Attributes attributes = manifest.getAttributes(path);
        if (attributes != null && (value2 = attributes.getValue(Attributes.Name.SEALED)) != null) {
            return value2.equalsIgnoreCase("true");
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        if (mainAttributes != null && (value = mainAttributes.getValue(Attributes.Name.SEALED)) != null) {
            return value.equalsIgnoreCase("true");
        }
        return false;
    }

    public static String getJavaVersion() {
        String ver = Runtime.version().toString();
        int plus = ver.indexOf(43);
        if (plus >= 0) {
            ver = ver.substring(0, plus);
        }
        return ver.replace('_', '.');
    }

    public static int getJavaMajorVersion() {
        return Runtime.version().version().get(0);
    }

    public static long getCurrentPid() {
        return ProcessHandle.current().pid();
    }
}

