/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.tabframe;

import com.github.weisj.darklaf.components.tabframe.JTabFrame;
import com.github.weisj.darklaf.components.tabframe.TabFrameTab;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TabFrameTabContainer
extends JPanel
implements TabFrameTab {
    protected final TabFrameTab oldTab;
    private JTabFrame parent;
    private Component content;
    private Alignment orientation;
    private boolean selected;
    private int index;
    private int accelerator;

    public TabFrameTabContainer(JTabFrame parent, JComponent content, TabFrameTab oldTab, Alignment alignment, int index) {
        super(new BorderLayout());
        this.parent = parent;
        this.oldTab = oldTab;
        this.accelerator = -1;
        this.setOpaque(false);
        this.setOrientation(alignment);
        this.setIndex(index);
        this.setContent(content);
    }

    @Override
    public String getUIClassID() {
        return "TabFrameTabContainerUI";
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        Component old = this.content;
        this.remove(content);
        this.content = content;
        this.add(content, "Center");
        this.firePropertyChange("content", old, content);
    }

    @Override
    public Color getBackground() {
        if (this.content != null && !this.content.isOpaque()) {
            return super.getBackground();
        }
        return this.content != null ? this.content.getBackground() : super.getBackground();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public Alignment getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(Alignment a) {
        if (this.orientation == a) {
            return;
        }
        Alignment oldOrientation = this.orientation;
        this.orientation = a;
        this.firePropertyChange("orientation", (Object)oldOrientation, (Object)this.orientation);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected == this.selected) {
            return;
        }
        boolean oldSelected = this.selected;
        this.selected = selected;
        this.firePropertyChange("selected", oldSelected, selected);
    }

    @Override
    public int getAccelerator() {
        return this.accelerator;
    }

    @Override
    public void setAccelerator(int accelerator) {
        if (this.accelerator == accelerator) {
            return;
        }
        int oldAccelerator = this.accelerator;
        this.accelerator = accelerator;
        this.firePropertyChange("accelerator", oldAccelerator, accelerator);
    }

    @Override
    public JTabFrame getTabFrame() {
        return this.parent;
    }

    @Override
    public void setTabFrame(JTabFrame parent) {
        JTabFrame old = this.parent;
        this.parent = parent;
        this.firePropertyChange("tabFrame", old, parent);
    }
}

