/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.graphics;

import com.github.weisj.darklaf.compatibility.SwingUtil;
import com.github.weisj.darklaf.graphics.AntialiasingImageFilter;
import com.github.weisj.darklaf.platform.SystemInfo;
import com.github.weisj.darklaf.ui.OpacityBufferedUI;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.ColorUtil;
import com.github.weisj.darklaf.util.ImageUtil;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.Scale;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.View;

public final class StringPainter {
    private static final Logger LOGGER = LogUtil.getLogger(StringPainter.class);
    private static boolean translucentAAPaintingEnabled = true;
    private static boolean experimentalAntialiasingEnabled = false;

    private StringPainter() {
    }

    public static void setExperimentalAntialiasingEnabled(boolean enabled) {
        experimentalAntialiasingEnabled = enabled;
    }

    public static void setTranslucentAAPaintingEnabled(boolean enabled) {
        translucentAAPaintingEnabled = enabled;
    }

    public static boolean isTranslucentAAPaintingEnabled() {
        return translucentAAPaintingEnabled;
    }

    public static boolean isExperimentalAntialiasingEnabled() {
        return experimentalAntialiasingEnabled;
    }

    public static <T extends JComponent> void drawString(Graphics g, T c, String text, Rectangle textRect) {
        StringPainter.drawString(g, c, text, textRect, SwingUtil.getFontMetrics(c, g));
    }

    public static <T extends JComponent> void drawString(Graphics g, T c, View view, String text, Rectangle textRect, FontMetrics fm) {
        StringPainter.drawStringImpl(g, c, view, text, textRect, c.getFont(), fm, -1);
    }

    public static <T extends JComponent> void drawString(Graphics g, T c, String text, Rectangle textRect, FontMetrics fm) {
        StringPainter.drawStringImpl(g, c, null, text, textRect, c.getFont(), fm, -1);
    }

    public static <T extends JComponent> void drawStringUnderlineCharAt(Graphics g, T c, String text, int mnemIndex, Rectangle textRect) {
        StringPainter.drawStringUnderlineCharAt(g, c, text, mnemIndex, textRect, c.getFont());
    }

    public static <T extends JComponent> void drawStringUnderlineCharAt(Graphics g, T c, String text, int mnemIndex, Rectangle textRect, Font f) {
        StringPainter.drawStringUnderlineCharAt(g, c, text, mnemIndex, textRect, f, SwingUtil.getFontMetrics(c, g));
    }

    public static <T extends JComponent> void drawStringUnderlineCharAt(Graphics g, T c, View view, String text, int mnemIndex, Rectangle textRect, Font font, FontMetrics fm) {
        StringPainter.drawStringImpl(g, c, view, text, textRect, font, fm, mnemIndex);
    }

    public static <T extends JComponent> void drawStringUnderlineCharAt(Graphics g, T c, String text, int mnemIndex, Rectangle textRect, Font font, FontMetrics fm) {
        StringPainter.drawStringImpl(g, c, null, text, textRect, font, fm, mnemIndex);
    }

    public static <T extends JComponent> void drawStringImpl(Graphics g, T c, View view, String text, Rectangle textRect, Font font, FontMetrics fm, int mnemIndex) {
        StringPainter.drawStringImpl(g, c, view, text, textRect, font, fm, mnemIndex, null);
    }

    private static Color effectiveBackgroundColor(JComponent c) {
        return c.getBackground();
    }

    public static <T extends JComponent> void drawStringImpl(Graphics g, T c, View view, String text, Rectangle textRect, Font font, FontMetrics fm, int mnemIndex, Color background) {
        View v;
        boolean paintOpaqueBuffered;
        if (text == null || text.equals("")) {
            return;
        }
        GraphicsContext context = GraphicsUtil.setupAntialiasing(g);
        int asc = fm.getAscent();
        int x = textRect.x;
        int y = textRect.y;
        Graphics2D drawingGraphics = (Graphics2D)g;
        BufferedImage img = null;
        Point textPos = null;
        Color fgColor = g.getColor();
        Color bgColor = background;
        Component window = StringPainter.getNonOpaqueWindow(c);
        boolean bl = paintOpaqueBuffered = window != null;
        if (paintOpaqueBuffered) {
            if (bgColor == null) {
                bgColor = StringPainter.effectiveBackgroundColor(c);
            }
            LOGGER.finest(() -> "Using opaque buffering for " + c);
            double scaleX = Scale.getScaleX((Graphics2D)g);
            double scaleY = Scale.getScaleX((Graphics2D)g);
            if (experimentalAntialiasingEnabled) {
                textPos = new Point(x, y);
                textPos.setLocation(SwingUtilities.convertPoint(c, textPos, window));
                textPos.setLocation((int)Math.round(scaleX * (double)textPos.x), (int)Math.round(scaleX * (double)textPos.y));
                Color fg = g.getColor();
                double brightness = ColorUtil.getPerceivedBrightness(fg);
                bgColor = brightness > 127.0 ? Color.BLACK : Color.WHITE;
            }
            img = ImageUtil.createCompatibleImage((int)Math.round(scaleX * (double)textRect.width), (int)Math.round(scaleY * (double)textRect.height));
            drawingGraphics = StringPainter.prepareImage(img, bgColor, fgColor, scaleX, scaleY);
            textRect.setLocation(0, 0);
        }
        drawingGraphics.setFont(font);
        View view2 = v = view != null ? view : PropertyUtil.getObject(c, "html", View.class);
        if (v != null) {
            v.paint(drawingGraphics, textRect);
        } else {
            int textY = textRect.y + asc;
            if (mnemIndex >= 0) {
                SwingUtil.drawStringUnderlineCharAt(c, drawingGraphics, text, mnemIndex, textRect.x, textY);
            } else {
                SwingUtil.drawString(c, drawingGraphics, text, textRect.x, textY);
            }
        }
        if (paintOpaqueBuffered) {
            drawingGraphics.dispose();
            Image result = StringPainter.postProcessImage((Graphics2D)g, img, textPos, bgColor, fgColor);
            g.drawImage(result, x, y, textRect.width, textRect.height, null);
        }
        context.restore();
    }

    private static Image postProcessImage(Graphics2D g, BufferedImage img, Point textPos, Color bgColor, Color fgColor) {
        if (experimentalAntialiasingEnabled) {
            BufferedImage destImg = StringPainter.getImage(g);
            AntialiasingImageFilter filter = new AntialiasingImageFilter(destImg, textPos.x, textPos.y, fgColor, bgColor);
            return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(img.getSource(), filter));
        }
        return img;
    }

    private static Component getNonOpaqueWindow(JComponent c) {
        boolean imgGraphics = false;
        Container window = c;
        if (translucentAAPaintingEnabled && SystemInfo.isWindows && !GraphicsUtil.isOpaqueBuffered(c)) {
            Container comp;
            for (comp = c; comp != null; comp = comp.getParent()) {
                Color bg = comp.getBackground();
                boolean bl = imgGraphics = bg != null && bg.getAlpha() < 255;
                if (imgGraphics) break;
            }
            if (imgGraphics) {
                window = DarkUIUtil.getWindow(comp);
            }
            return imgGraphics ? window : null;
        }
        return null;
    }

    private static BufferedImage getImage(Graphics2D graphics2D) {
        try {
            Field imgField;
            Field surfaceField = graphics2D.getClass().getField("surfaceData");
            Object surfaceDataValue = surfaceField.get(graphics2D);
            if (surfaceDataValue == null) {
                return null;
            }
            try {
                imgField = surfaceDataValue.getClass().getDeclaredField("bufImg");
            }
            catch (Exception ignored) {
                imgField = surfaceDataValue.getClass().getField("offscreenImage");
            }
            imgField.setAccessible(true);
            Object img = imgField.get(surfaceDataValue);
            if (img instanceof BufferedImage) {
                return (BufferedImage)img;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Couldn't retrieve Graphics backing image", e);
        }
        return null;
    }

    private static Graphics2D prepareImage(BufferedImage img, Color background, Color color, double xScale, double yScale) {
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(background);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        g.setColor(color);
        g.setClip(0, 0, img.getWidth(), img.getHeight());
        g.scale(xScale, yScale);
        return g;
    }

    public static void paintOpacityBufferedUI(Graphics g, JComponent c, OpacityBufferedUI ui) {
        boolean opaqueBuffered;
        boolean bl = opaqueBuffered = translucentAAPaintingEnabled && GraphicsUtil.isOpaqueBuffered(c);
        if (opaqueBuffered) {
            StringPainter.paintOpacityBuffered(g, c, ui);
        } else {
            ui.updateUI(g, c);
        }
    }

    public static void paintOpacityBuffered(Graphics g, JComponent c, OpacityBufferedUI ui) {
        double scaleX = Scale.getScaleX((Graphics2D)g);
        double scaleY = Scale.getScaleX((Graphics2D)g);
        BufferedImage img = ImageUtil.createCompatibleImage((int)Math.round(scaleX * (double)c.getWidth()), (int)Math.round(scaleY * (double)c.getHeight()));
        Graphics imgGraphics = img.getGraphics();
        imgGraphics.setColor(c.getBackground());
        imgGraphics.fillRect(0, 0, c.getWidth(), c.getHeight());
        imgGraphics.setClip(0, 0, img.getWidth(), img.getHeight());
        ((Graphics2D)imgGraphics).scale(scaleX, scaleY);
        ui.updateUI(imgGraphics, c);
        imgGraphics.dispose();
        g.drawImage(img, 0, 0, c.getWidth(), c.getHeight(), null);
    }
}

