/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.macos;

import com.github.weisj.darklaf.platform.CustomTitlePane;
import com.github.weisj.darklaf.platform.DecorationsProvider;
import com.github.weisj.darklaf.platform.SystemInfo;
import com.github.weisj.darklaf.platform.TitlePaneLayoutInfo;
import com.github.weisj.darklaf.platform.UnsupportedProviderException;
import com.github.weisj.darklaf.platform.macos.JNIDecorationsMacOS;
import com.github.weisj.darklaf.platform.macos.MacOSLibrary;
import com.github.weisj.darklaf.platform.macos.ui.MacOSTitlePane;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Collections;
import java.util.List;
import javax.swing.JRootPane;

public class MacOSDecorationsProvider
implements DecorationsProvider {
    public MacOSDecorationsProvider() throws UnsupportedProviderException {
        if (!SystemInfo.isMacOSYosemite) {
            throw new UnsupportedProviderException("Only macOS Yosemite or later is supported");
        }
        if (!MacOSLibrary.get().canLoad()) {
            throw new UnsupportedProviderException("Can't load native library");
        }
    }

    @Override
    public CustomTitlePane createTitlePane(JRootPane rootPane, int decorationStyle, Window window) {
        return new MacOSTitlePane(rootPane, window);
    }

    @Override
    public boolean isCustomDecorationSupported() {
        return MacOSLibrary.get().isLoaded();
    }

    @Override
    public void initialize() {
        MacOSLibrary.get().updateLibrary();
    }

    @Override
    public List<String> getPropertyResourcePaths() {
        return Collections.singletonList("macos_decorations");
    }

    @Override
    public boolean supportsNativeTitleLabel() {
        return SystemInfo.isMacOSMojave;
    }

    @Override
    public TitlePaneLayoutInfo titlePaneLayoutInfo(CustomTitlePane customTitlePane) {
        if (!(customTitlePane instanceof MacOSTitlePane)) {
            throw new IllegalStateException();
        }
        long hwnd = ((MacOSTitlePane)customTitlePane).windowHandle();
        if (hwnd == 0L) {
            throw new IllegalStateException("Window isn't displayable (but has to in order to compute the title pane layout. If you need this information before the window is displayed call `frame.addNotify()` to make it displayable.");
        }
        float[] b = JNIDecorationsMacOS.windowButtonRect(((MacOSTitlePane)customTitlePane).windowHandle());
        return new TitlePaneLayoutInfo(new Rectangle((int)b[0], (int)b[1], (int)b[2], (int)b[3]));
    }
}

