/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.task;

import com.github.weisj.darklaf.properties.color.DarkColorModelHSB;
import com.github.weisj.darklaf.properties.parser.Parser;
import com.github.weisj.darklaf.properties.uiresource.DarkColorUIResource;
import com.github.weisj.darklaf.task.ColorAdjustmentTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.Types;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class AccentColorAdjustmentTask
extends ColorAdjustmentTask {
    private static final Logger LOGGER = LogUtil.getLogger(AccentColorAdjustmentTask.class);
    private static final String MAIN_ACCENT_LIST_KEY = "accent.propertyList";
    private static final String SELECTION_ACCENT_LIST_KEY = "selection.propertyList";

    @Override
    protected void runTask(Theme currentTheme, Properties properties) {
        Color accentColor = currentTheme.getAccentColorRule().getAccentColor();
        Color selectionColor = currentTheme.getAccentColorRule().getSelectionColor();
        this.applyColors(currentTheme, properties, accentColor, selectionColor);
    }

    public void applyColors(Theme currentTheme, Properties properties, Color accentColor, Color selectionColor) {
        if (!currentTheme.supportsCustomAccentColor() && !currentTheme.supportsCustomSelectionColor()) {
            return;
        }
        if (accentColor == null && selectionColor == null) {
            return;
        }
        Properties props = currentTheme.loadAccentProperties();
        if (props == null || props.isEmpty()) {
            return;
        }
        if (accentColor != null && currentTheme.supportsCustomAccentColor()) {
            this.adjustColors(MAIN_ACCENT_LIST_KEY, accentColor, props, properties);
        }
        if (selectionColor != null && currentTheme.supportsCustomSelectionColor()) {
            this.adjustColors(SELECTION_ACCENT_LIST_KEY, selectionColor, props, properties);
        }
    }

    private void adjustColors(String listKey, Color c, Properties listProperties, Properties properties) {
        this.adjust(listKey, listProperties, map -> {
            double[] hsb = DarkColorModelHSB.RGBtoHSBValues(c.getRed(), c.getGreen(), c.getBlue());
            this.adjustColorList((Map<?, ?>)map, hsb, properties);
        });
    }

    private void adjustColorList(Map<?, ?> map, double[] hsb, Properties properties) {
        ColorInfo info = new ColorInfo();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.setColorInfo(entry, info);
            if (info.key == null) continue;
            Object c = this.mapColor(info, hsb, properties);
            if (c instanceof Color) {
                properties.put(info.key, c);
                continue;
            }
            LOGGER.warning("Color with key '" + info.key + "' could not be adjusted because the value '" + c + ", '" + c.getClass() + " is not a color");
        }
    }

    private void setColorInfo(Map.Entry<?, ?> o, ColorInfo info) {
        List<Integer> modifiers;
        info.set(null, 0, 0, 0);
        String targetKey = Types.safeCast(o.getKey(), String.class);
        List<Integer> list = modifiers = o.getValue() == Parser.EMPTY_VALUE ? Arrays.asList(100, 100, 100) : Types.safeCast(o.getValue(), List.class);
        if (targetKey == null) {
            LOGGER.severe("Target key is null");
            return;
        }
        if (!(modifiers != null && modifiers.size() == 3 && modifiers.get(0) instanceof Integer && modifiers.get(1) instanceof Integer && modifiers.get(2) instanceof Integer)) {
            LOGGER.severe("Incorrect modifier list " + modifiers);
            return;
        }
        info.set(targetKey, modifiers.get(0), modifiers.get(1), modifiers.get(2));
    }

    private Object mapColor(ColorInfo info, double[] hsbMatch, Properties properties) {
        Object obj = properties.get(info.key);
        if (obj instanceof Color) {
            Color color = DarkColorModelHSB.getColorFromHSBValues(this.mapValue(hsbMatch[0], info.hAdj), this.mapValue(hsbMatch[1], info.sAdj), this.mapValue(hsbMatch[2], info.bAdj));
            return new DarkColorUIResource(color);
        }
        return obj;
    }

    private double mapValue(double value, int adjustment) {
        return value * ((double)adjustment / 100.0);
    }

    private static class ColorInfo {
        private String key;
        private int hAdj;
        private int sAdj;
        private int bAdj;

        private ColorInfo() {
        }

        private void set(String key, int hAdj, int sAdj, int bAdj) {
            this.key = key;
            this.hAdj = hAdj;
            this.sAdj = sAdj;
            this.bAdj = bAdj;
        }
    }
}

