/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.colorchooser;

import com.github.weisj.darklaf.compatibility.SwingUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DarkPreviewPanel
extends JPanel {
    private static final int SQUARE_SIZE = 28;
    private static final int SQUARE_GAP = 4;
    private static final int INNER_GAP = 4;
    private static final int SWATCH_WIDTH = 75;
    private static final int TEXT_GAP = 5;
    private String sampleText;
    private Color oldColor = null;

    @Override
    public void paintComponent(Graphics g) {
        if (this.oldColor == null) {
            this.oldColor = this.getForeground();
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.getComponentOrientation().isLeftToRight()) {
            int squareWidth = this.paintSquares(g, 0);
            int textWidth = this.paintText(g, squareWidth);
            this.paintSwatch(g, squareWidth + textWidth);
        } else {
            int swatchWidth = this.paintSwatch(g, 0);
            int textWidth = this.paintText(g, swatchWidth);
            this.paintSquares(g, swatchWidth + textWidth);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        JComponent host = this.getColorChooser();
        if (host == null) {
            host = this;
        }
        FontMetrics fm = host.getFontMetrics(this.getFont());
        int height = fm.getHeight();
        int width = SwingUtil.stringWidth(host, fm, this.getSampleText());
        int y = height * 3 + 15;
        int x = 167 + width + 15;
        return new Dimension(x, y);
    }

    private int paintSquares(Graphics g, int offsetX) {
        Color color = this.getForeground();
        g.setColor(Color.white);
        g.fillRect(offsetX, 0, 28, 28);
        g.setColor(color);
        g.fillRect(offsetX + 4, 4, 20, 20);
        g.setColor(Color.white);
        g.fillRect(offsetX + 8, 8, 12, 12);
        g.setColor(color);
        g.fillRect(offsetX, 32, 28, 28);
        g.translate(32, 0);
        g.setColor(Color.black);
        g.fillRect(offsetX, 0, 28, 28);
        g.setColor(color);
        g.fillRect(offsetX + 4, 4, 20, 20);
        g.setColor(Color.white);
        g.fillRect(offsetX + 8, 8, 12, 12);
        g.translate(-32, 0);
        g.translate(32, 32);
        g.setColor(Color.white);
        g.fillRect(offsetX, 0, 28, 28);
        g.setColor(color);
        g.fillRect(offsetX + 4, 4, 20, 20);
        g.translate(-32, -32);
        g.translate(64, 0);
        g.setColor(Color.white);
        g.fillRect(offsetX, 0, 28, 28);
        g.setColor(color);
        g.fillRect(offsetX + 4, 4, 20, 20);
        g.setColor(Color.black);
        g.fillRect(offsetX + 8, 8, 12, 12);
        g.translate(-64, 0);
        g.translate(64, 32);
        g.setColor(Color.black);
        g.fillRect(offsetX, 0, 28, 28);
        g.setColor(color);
        g.fillRect(offsetX + 4, 4, 20, 20);
        g.translate(-64, -32);
        return 92;
    }

    private int paintText(Graphics g, int offsetX) {
        GraphicsContext config = GraphicsUtil.setupAntialiasing(g);
        g.setFont(this.getFont());
        JComponent host = this.getColorChooser();
        if (host == null) {
            host = this;
        }
        FontMetrics fm = SwingUtil.getFontMetrics(host, g);
        int ascent = fm.getAscent();
        int height = fm.getHeight();
        int width = SwingUtil.stringWidth(host, fm, this.getSampleText());
        int textXOffset = offsetX + 5;
        Color color = this.getForeground();
        g.setColor(color);
        SwingUtil.drawString(host, g, this.getSampleText(), textXOffset + 2, ascent);
        g.fillRect(textXOffset, height + 5, width + 5, height + 2);
        g.setColor(Color.black);
        SwingUtil.drawString(host, g, this.getSampleText(), textXOffset + 2, height + ascent + 5 + 2);
        g.setColor(Color.white);
        g.fillRect(textXOffset, (height + 5) * 2, width + 5, height + 2);
        g.setColor(color);
        SwingUtil.drawString(host, g, this.getSampleText(), textXOffset + 2, (height + 5) * 2 + ascent + 2);
        config.restore();
        return width + 15;
    }

    private int paintSwatch(Graphics g, int offsetX) {
        g.setColor(this.oldColor);
        g.fillRect(offsetX, 0, 75, 30);
        g.setColor(this.getForeground());
        g.fillRect(offsetX, 30, 75, 30);
        return offsetX + 75;
    }

    private JColorChooser getColorChooser() {
        return (JColorChooser)SwingUtilities.getAncestorOfClass(JColorChooser.class, this);
    }

    private String getSampleText() {
        if (this.sampleText == null) {
            this.sampleText = UIManager.getString((Object)"ColorChooser.sampleText", this.getLocale());
        }
        return this.sampleText;
    }
}

