/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.scrollpane;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.graphics.SizedPainter;
import com.github.weisj.darklaf.ui.scrollpane.DarkScrollBarListener;
import com.github.weisj.darklaf.ui.scrollpane.EmptyButton;
import com.github.weisj.darklaf.ui.scrollpane.ScrollBarConstants;
import com.github.weisj.darklaf.util.ColorUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class DarkScrollBarUI
extends BasicScrollBarUI
implements ScrollBarConstants {
    protected static final AlphaComposite COMPOSITE = AlphaComposite.getInstance(3);
    protected DarkScrollBarListener<?> scrollBarListener;
    protected Color thumbBorderColor;
    protected Color thumbFadeStartColor;
    protected Color thumbFadeEndColor;
    protected Color trackBackground;
    protected int smallSize;
    protected int size;
    protected float thumbAlpha;
    private PropertyChangeListener darkPropertyChangeListener;
    private SizedPainter<JScrollBar> backgroundPainter;
    private final Rectangle backgroundRect = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return new DarkScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.scrollbar.setFocusable(false);
    }

    @Override
    protected void installDefaults() {
        int incGap = UIManager.getInt("ScrollBar.incrementButtonGap");
        int decGap = UIManager.getInt("ScrollBar.decrementButtonGap");
        try {
            UIManager.put("ScrollBar.incrementButtonGap", 0);
            UIManager.put("ScrollBar.decrementButtonGap", 0);
            super.installDefaults();
        }
        finally {
            UIManager.put("ScrollBar.incrementButtonGap", incGap);
            UIManager.put("ScrollBar.decrementButtonGap", decGap);
        }
        PropertyUtil.installProperty(this.scrollbar, "JScrollBar.highlightOnScroll", UIManager.getBoolean("ScrollBar.highlightOnScroll"));
        this.thumbBorderColor = UIManager.getColor("ScrollBar.thumbBorderColor");
        this.thumbFadeStartColor = UIManager.getColor("ScrollBar.fadeStartColor");
        this.thumbFadeEndColor = UIManager.getColor("ScrollBar.fadeEndColor");
        this.trackBackground = UIManager.getColor("ScrollBar.trackColor");
        this.smallSize = UIManager.getInt("ScrollBar.smallWidth");
        this.size = UIManager.getInt("ScrollBar.width");
        this.thumbAlpha = (float)UIManager.getInt("ScrollBar.thumbAlpha") / 100.0f;
        this.updateBackgroundPainter(this.scrollbar.getClientProperty("JScrollBar.backgroundPainter"));
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.scrollBarListener = this.createScrollBarListener();
        this.scrollbar.addAdjustmentListener(this.scrollBarListener);
        this.scrollbar.addMouseMotionListener(this.scrollBarListener);
        this.scrollbar.addMouseListener(this.scrollBarListener);
        this.scrollbar.addMouseWheelListener(this.scrollBarListener);
        this.darkPropertyChangeListener = this::onPropertyChange;
        this.scrollbar.addPropertyChangeListener(this.darkPropertyChangeListener);
    }

    protected DarkScrollBarListener<?> createScrollBarListener() {
        return new DarkScrollBarListener<DarkScrollBarUI>(this.scrollbar, this);
    }

    @Override
    protected BasicScrollBarUI.ModelListener createModelListener() {
        return new BasicScrollBarUI.ModelListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DarkScrollBarUI.this.scrollbar != null) {
                    super.stateChanged(e);
                }
            }
        };
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new EmptyButton();
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new EmptyButton();
    }

    @Override
    protected void uninstallListeners() {
        if (this.scrollTimer != null) {
            super.uninstallListeners();
        }
        this.scrollbar.removeMouseListener(this.scrollBarListener);
        this.scrollbar.removeMouseWheelListener(this.scrollBarListener);
        this.scrollbar.removeMouseMotionListener(this.scrollBarListener);
        this.scrollbar.removeAdjustmentListener(this.scrollBarListener);
        this.scrollBarListener.uninstall();
        this.scrollBarListener = null;
        this.scrollbar.removePropertyChangeListener(this.darkPropertyChangeListener);
        this.darkPropertyChangeListener = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.backgroundPainter != null) {
            Graphics2D bg = (Graphics2D)g.create();
            this.backgroundPainter.paint(bg, (JScrollBar)c, this.backgroundRect.width, this.backgroundRect.height);
        }
        super.paint(g, c);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle bounds) {
        float trackAlpha;
        if (c.isOpaque()) {
            g.setColor(this.scrollbar.getBackground());
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        if ((trackAlpha = this.scrollBarListener.getTrackAlpha()) == 0.0f) {
            return;
        }
        g.setColor(this.getTrackColor());
        ((Graphics2D)g).setComposite(COMPOSITE.derive(trackAlpha));
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!thumbBounds.isEmpty() && this.scrollbar.isEnabled()) {
            this.paintMaxiThumb((Graphics2D)g, thumbBounds);
        }
    }

    protected void paintMaxiThumb(Graphics2D g, Rectangle rect) {
        g.setComposite(COMPOSITE.derive(this.thumbAlpha));
        g.setColor(this.getThumbBorderColor());
        PaintUtil.drawRect((Graphics)g, rect.x, rect.y, rect.width, rect.height, 1);
        g.setColor(this.getThumbColor());
        PaintUtil.fillRect(g, rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
    }

    protected Color getThumbBorderColor() {
        double percent = Math.min(1.0, Math.max(0.0, (double)(1.0f - (this.scrollBarListener.getThumbAlpha() - this.thumbAlpha))));
        return ColorUtil.blendColors(this.thumbBorderColor, this.thumbColor, percent);
    }

    protected Color getThumbColor() {
        return ColorUtil.blendColors(this.thumbFadeEndColor, this.thumbFadeStartColor, this.scrollBarListener.getThumbAlpha());
    }

    @Override
    public boolean getSupportsAbsolutePositioning() {
        return true;
    }

    protected Color getTrackColor() {
        return this.trackBackground;
    }

    protected int getThickness() {
        return ScrollBarConstants.isSmall(this.scrollbar) ? this.smallSize : this.size;
    }

    @Override
    public Rectangle getTrackBounds() {
        return super.getTrackBounds();
    }

    @Override
    public Rectangle getThumbBounds() {
        return super.getThumbBounds();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension size = this.getMinimumSizeWithoutBackgroundPainter();
        if (this.backgroundPainter != null) {
            Dimension bgSize = this.backgroundPainter.preferredSize(new Dimension(size));
            if (this.scrollbar.getOrientation() == 0) {
                size.height = Math.max(bgSize.height, size.height);
            } else {
                size.width = Math.max(bgSize.width, size.width);
            }
        }
        return size;
    }

    private Dimension getMinimumSizeWithoutBackgroundPainter() {
        return this.getMinimumThumbSize();
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        int size = this.getThickness();
        if (this.scrollbar.getOrientation() == 0) {
            return new Dimension(2 * size, size);
        }
        return new Dimension(size, 2 * size);
    }

    @Override
    public void layoutContainer(Container scrollbarContainer) {
        try {
            super.layoutContainer(scrollbarContainer);
            if (!this.isDragging && this.backgroundPainter != null) {
                Dimension size = this.getMinimumSizeWithoutBackgroundPainter();
                this.backgroundRect.setBounds(this.trackRect);
                if (this.scrollbar.getOrientation() == 0) {
                    this.trackRect.y = this.trackRect.y + this.trackRect.height - size.height;
                    this.trackRect.height = size.height;
                    this.thumbRect.y = this.thumbRect.y + this.thumbRect.height - size.height;
                    this.thumbRect.height = size.height;
                } else {
                    this.trackRect.x = this.trackRect.x + this.trackRect.width - size.width;
                    this.trackRect.width = size.width;
                    this.thumbRect.x = this.thumbRect.x + this.thumbRect.width - size.width;
                    this.thumbRect.width = size.width;
                }
                this.backgroundPainter.doLayout(this.backgroundRect);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void updateBackgroundPainter(Object painter) {
        this.backgroundPainter = painter instanceof SizedPainter ? (SizedPainter)painter : null;
    }

    private void onPropertyChange(PropertyChangeEvent e) {
        String key = e.getPropertyName();
        if ("JScrollBar.backgroundPainter".equals(key)) {
            this.updateBackgroundPainter(e.getNewValue());
        }
    }
}

