/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUIBridge;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class TabbedPaneHandler
implements ChangeListener,
ContainerListener,
FocusListener,
MouseListener,
MouseMotionListener,
PropertyChangeListener {
    private final DarkTabbedPaneUIBridge ui;

    protected TabbedPaneHandler(DarkTabbedPaneUIBridge ui) {
        this.ui = ui;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        JTabbedPane pane = (JTabbedPane)e.getSource();
        String name = e.getPropertyName();
        boolean isScrollLayout = this.ui.scrollableTabLayoutEnabled();
        if (Objects.equals(name, "mnemonicAt")) {
            this.ui.updateMnemonics();
            pane.repaint();
        } else if (Objects.equals(name, "displayedMnemonicIndexAt")) {
            pane.repaint();
        } else if (Objects.equals(name, "indexForTitle")) {
            this.ui.calculatedBaseline = false;
            Integer index = (Integer)e.getNewValue();
            this.updateHtmlViews(index, false);
        } else if (Objects.equals(name, "tabLayoutPolicy")) {
            this.ui.uninstallUI(pane);
            this.ui.installUI(pane);
            this.ui.calculatedBaseline = false;
        } else if (Objects.equals(name, "tabPlacement")) {
            if (this.ui.scrollableTabLayoutEnabled()) {
                this.ui.tabScroller.createButtons(this.ui);
            }
            this.ui.calculatedBaseline = false;
        } else if (Objects.equals(name, "opaque") && isScrollLayout) {
            boolean newVal = (Boolean)e.getNewValue();
            this.ui.tabScroller.tabPanel.setOpaque(newVal);
            this.ui.tabScroller.viewport.setOpaque(newVal);
        } else if (Objects.equals(name, "background") && isScrollLayout) {
            Color newVal = (Color)e.getNewValue();
            this.ui.tabScroller.tabPanel.setBackground(newVal);
            this.ui.tabScroller.viewport.setBackground(newVal);
        } else if (Objects.equals(name, "indexForTabComponent")) {
            Component c;
            if (this.ui.tabContainer != null) {
                this.ui.tabContainer.removeUnusedTabComponents();
            }
            if ((c = this.ui.tabPane.getTabComponentAt((Integer)e.getNewValue())) != null) {
                if (this.ui.tabContainer == null) {
                    this.ui.installTabContainer();
                } else {
                    this.ui.tabContainer.add(c);
                }
            }
            this.ui.tabPane.revalidate();
            this.ui.tabPane.repaint();
            this.ui.calculatedBaseline = false;
        } else if (Objects.equals(name, "indexForNullComponent")) {
            this.ui.isRunsDirty = true;
            this.updateHtmlViews((Integer)e.getNewValue(), true);
        } else if (Objects.equals(name, "font") || DarkUIUtil.isScaleChanged(e)) {
            this.ui.calculatedBaseline = false;
        }
    }

    protected void updateHtmlViews(int index, boolean inserted) {
        String title = this.ui.tabPane.getTitleAt(index);
        boolean isHTML = BasicHTML.isHTMLString(title);
        if (isHTML) {
            if (this.ui.htmlViews == null) {
                this.ui.htmlViews = this.ui.createHTMLVector();
            } else {
                View v = BasicHTML.createHTMLView(this.ui.tabPane, title);
                this.setHtmlView(v, inserted, index);
            }
        } else if (this.ui.htmlViews != null) {
            this.setHtmlView(null, inserted, index);
        }
        this.ui.updateMnemonics();
    }

    protected void setHtmlView(View v, boolean inserted, int index) {
        if (inserted || index >= this.ui.htmlViews.size()) {
            this.ui.htmlViews.insertElementAt(v, index);
        } else {
            this.ui.htmlViews.setElementAt(v, index);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JTabbedPane tabPane = (JTabbedPane)e.getSource();
        tabPane.revalidate();
        tabPane.repaint();
        this.ui.setFocusIndex(tabPane.getSelectedIndex(), false);
        if (this.ui.scrollableTabLayoutEnabled()) {
            this.ui.ensureCurrentLayout();
            int index = tabPane.getSelectedIndex();
            if (index < this.ui.rects.length && index != -1) {
                this.ui.tabScroller.tabPanel.scrollRectToVisible((Rectangle)this.ui.rects[index].clone());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.ui.tabPane.isEnabled()) {
            return;
        }
        int tabIndex = this.ui.tabForCoordinate(this.ui.tabPane, e.getX(), e.getY());
        if (tabIndex >= 0 && this.ui.tabPane.isEnabledAt(tabIndex)) {
            if (tabIndex != this.ui.tabPane.getSelectedIndex()) {
                this.ui.tabPane.setSelectedIndex(tabIndex);
            } else if (this.ui.tabPane.isRequestFocusEnabled()) {
                this.ui.tabPane.requestFocusInWindow();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.ui.setRolloverTab(e.getX(), e.getY());
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.ui.setRolloverTab(-1);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.ui.setRolloverTab(e.getX(), e.getY());
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.ui.setFocusIndex(this.ui.tabPane.getSelectedIndex(), true);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.ui.repaintTab(this.ui.focusIndex);
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        JTabbedPane tp = (JTabbedPane)e.getContainer();
        Component child = e.getChild();
        if (child instanceof UIResource) {
            return;
        }
        this.ui.isRunsDirty = true;
        this.updateHtmlViews(tp.indexOfComponent(child), true);
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        JTabbedPane tp = (JTabbedPane)e.getContainer();
        Component child = e.getChild();
        if (child instanceof UIResource) {
            return;
        }
        int index = PropertyUtil.getInteger(tp, "__index_to_remove__", -1);
        if (index >= 0) {
            if (this.ui.htmlViews != null && this.ui.htmlViews.size() > index) {
                this.ui.htmlViews.removeElementAt(index);
            }
            tp.putClientProperty("__index_to_remove__", null);
        }
        this.ui.isRunsDirty = true;
        this.ui.updateMnemonics();
        this.ui.validateFocusIndex();
    }
}

