/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabframe;

import com.github.weisj.darklaf.components.tabframe.TabFrameTab;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.ui.util.SwingXUtil;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLayer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class TabDragListener
extends MouseAdapter {
    private final TabFrameTab tabComponent;
    protected Point origin;

    public TabDragListener(TabFrameTab tabComponent) {
        this.tabComponent = tabComponent;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.origin = e.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.origin = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.tabComponent.isEnabled()) {
            return;
        }
        if (this.origin == null) {
            this.origin = e.getPoint();
        }
        if (this.distance(this.origin, e.getPoint()) < 100) {
            return;
        }
        TransferHandler th = this.tabComponent.getTabFrame().getTransferHandler();
        if (th != null && this.tabComponent.getTabFrame().isDndEnabled()) {
            Point p = e.getPoint();
            JLayer layer = DarkUIUtil.getParentOfType(JLayer.class, this.tabComponent.getComponent(), 3);
            p = SwingXUtil.convertPointToParent(this.tabComponent.getComponent(), layer, p);
            p = SwingUtilities.convertPoint(layer != null ? layer : this.tabComponent.getComponent().getParent(), p, this.tabComponent.getTabFrame());
            this.tabComponent.getTabFrame().initTransfer(this.tabComponent.getOrientation(), this.tabComponent.getIndex());
            th.exportAsDrag(this.tabComponent.getTabFrame(), new MouseEvent(this.tabComponent.getTabFrame(), e.getID(), e.getWhen(), e.getModifiersEx(), p.x, p.y, e.getClickCount(), e.isPopupTrigger(), e.getButton()), 2);
        }
    }

    protected int distance(Point p1, Point p2) {
        return (p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y);
    }
}

