/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table.renderer;

import java.awt.BorderLayout;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class IconWrapper
extends JPanel {
    private final JLabel label;
    private JComponent c;
    private int iconGap;

    protected IconWrapper() {
        this.setLayout(new BorderLayout());
        this.label = new JLabel();
        this.label.setIconTextGap(0);
        this.add(this.label);
    }

    protected void setIconGap(int iconGap) {
        this.iconGap = iconGap;
    }

    protected void init(JComponent component, Icon icon, ComponentOrientation orientation) {
        this.setComponentOrientation(orientation);
        if (this.c != null) {
            this.remove(this.c);
        }
        this.add(component);
        this.setComponentZOrder(component, 0);
        this.setComponentZOrder(this.label, 1);
        this.c = component;
        this.label.setIcon(icon);
    }

    @Override
    public void doLayout() {
        if (this.c == null) {
            return;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        Border b = this.c.getBorder();
        Insets ins = new Insets(0, 0, 0, 0);
        Dimension labelSize = this.label.getPreferredSize();
        int gap = this.getIconCompGap();
        if (b != null) {
            ins = b.getBorderInsets(this.c);
        }
        if (this.getComponentOrientation().isLeftToRight()) {
            this.label.setBounds(ins.left + gap, 0, labelSize.width + 1, h);
            this.c.setBounds(ins.left + labelSize.width + 2 * gap - 1, 0, w - ins.left - labelSize.width - 2 * gap + 1, h);
        } else {
            this.c.setBounds(0, 0, w - ins.right - labelSize.width - gap - 1, h);
            this.label.setBounds(w - ins.right - labelSize.width - gap - 1, 0, labelSize.width + 1, h);
        }
    }

    public int getIconCompGap() {
        return this.iconGap;
    }
}

