/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tree;

import com.github.weisj.darklaf.components.tristate.TristateCheckBox;
import com.github.weisj.darklaf.components.tristate.TristateState;
import com.github.weisj.darklaf.delegate.TreeCellEditorDelegate;
import com.github.weisj.darklaf.ui.tree.DarkTreeCellEditor;
import com.github.weisj.darklaf.ui.tree.DarkTreeCellRendererDelegate;
import com.github.weisj.darklaf.ui.tree.DarkTreeUI;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class DarkDefaultTreeEditor
extends DefaultTreeCellEditor {
    private static final DarkTreeCellEditor checkBoxEditor = new DarkTreeCellEditor(new JCheckBox());
    private static final DarkTreeCellEditor radioButtonEditor = new DarkTreeCellEditor(new JRadioButton());
    private static final DarkTreeCellEditor tristateButtonEditor = new DarkTreeCellEditor(new TristateCheckBox()){

        @Override
        public Object getCellEditorValue() {
            return ((TristateCheckBox)this.editorComponent).getState();
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            Component component = super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
            if (component instanceof TristateCheckBox) {
                ((TristateCheckBox)component).setAllowsIndeterminate(!leaf);
            }
            return component;
        }
    };
    private boolean lastEventBooleanEditor;

    public DarkDefaultTreeEditor(JTree tree, DefaultTreeCellRenderer renderer) {
        this(tree, renderer, null);
    }

    public DarkDefaultTreeEditor(final JTree tree, DefaultTreeCellRenderer renderer, DarkTreeCellEditor editor) {
        super(tree, renderer, editor);
        this.realEditor = new TreeCellEditorDelegate(this.realEditor){

            @Override
            public Object getCellEditorValue() {
                Object value = DarkDefaultTreeEditor.this.getValue(tree, DarkDefaultTreeEditor.this.lastRow);
                if (DarkDefaultTreeEditor.this.isBooleanRenderer(value, tree)) {
                    return DarkDefaultTreeEditor.this.getBooleanEditor(tree).getCellEditorValue();
                }
                if (value instanceof TristateState) {
                    return tristateButtonEditor.getCellEditorValue();
                }
                return super.getCellEditorValue();
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                Object value = DarkDefaultTreeEditor.this.getValue(tree, tree.getLeadSelectionRow());
                if (DarkDefaultTreeEditor.this.isBooleanRenderer(value, tree)) {
                    return DarkDefaultTreeEditor.this.getBooleanEditor(tree).isCellEditable(anEvent);
                }
                if (value instanceof TristateState) {
                    return tristateButtonEditor.isCellEditable(anEvent);
                }
                return super.isCellEditable(anEvent);
            }
        };
    }

    @Override
    protected TreeCellEditor createTreeCellEditor() {
        Border border = UIManager.getBorder("Tree.editorBorder");
        JTextField textField = new JTextField();
        textField.setBorder(border);
        textField.putClientProperty("JComponent.isTreeEditor", true);
        DefaultCellEditor editor = new DefaultCellEditor(textField);
        editor.setClickCountToStart(1);
        return editor;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        Component comp = super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        comp.setComponentOrientation(tree.getComponentOrientation());
        Object unwrapped = DarkTreeCellRendererDelegate.unwrapValue(value);
        if (this.isBooleanRenderer(unwrapped, tree)) {
            Component editor = this.getBooleanEditor(tree).getTreeCellEditorComponent(tree, unwrapped, isSelected, expanded, leaf, row);
            this.prepareBooleanEditor(comp, editor, tree);
        } else if (unwrapped instanceof TristateState) {
            Component editor = tristateButtonEditor.getTreeCellEditorComponent(tree, unwrapped, isSelected, expanded, leaf, row);
            this.prepareBooleanEditor(comp, editor, tree);
        }
        return comp;
    }

    protected void prepareBooleanEditor(Component comp, Component component, JTree tree) {
        ((Container)comp).remove(this.editingComponent);
        this.editingComponent = component;
        this.editingComponent.setFont(tree.getFont());
        ((Container)comp).add(this.editingComponent);
    }

    protected DarkTreeCellEditor getBooleanEditor(JTree table) {
        if (PropertyUtil.isPropertyEqual(table, "JTree.booleanRenderType", "radioButton")) {
            return radioButtonEditor;
        }
        return checkBoxEditor;
    }

    protected Object getValue(JTree tree, int row) {
        TreePath path = tree.getPathForRow(row);
        if (path == null) {
            return false;
        }
        return DarkTreeCellRendererDelegate.unwrapValue(path.getLastPathComponent());
    }

    protected boolean isBooleanRenderer(Object value, JTree tree) {
        return value instanceof Boolean && DarkTreeCellRendererDelegate.isBooleanRenderingEnabled(tree);
    }

    @Override
    protected boolean canEditImmediately(EventObject event) {
        int row;
        Rectangle bounds;
        Point p;
        JTree tree = this.getTree(event);
        if (tree != null && (p = this.getPoint(event)) != null && (bounds = tree.getRowBounds(row = tree.getRowForLocation(p.x, p.y))) != null) {
            Object value = this.getValue(tree, row);
            JComponent button = null;
            if (this.isBooleanRenderer(value, tree)) {
                button = this.getBooleanRendererComponent(tree);
            } else if (value instanceof TristateState) {
                button = this.getTristateRendererComponent(tree);
            }
            if (button != null) {
                this.lastEventBooleanEditor = true;
                p.x -= bounds.x + button.getX();
                p.y -= bounds.y + button.getY();
                button.putClientProperty("JToggleButton.clearHitArea", true);
                return button.contains(p);
            }
        }
        this.lastEventBooleanEditor = false;
        return super.canEditImmediately(event);
    }

    @Override
    protected boolean shouldStartEditingTimer(EventObject event) {
        return !this.lastEventBooleanEditor && super.shouldStartEditingTimer(event);
    }

    protected JTree getTree(EventObject eventObject) {
        return eventObject != null && eventObject.getSource() instanceof JTree ? (JTree)eventObject.getSource() : null;
    }

    protected Point getPoint(EventObject eventObject) {
        return eventObject instanceof MouseEvent ? ((MouseEvent)eventObject).getPoint() : null;
    }

    protected DarkTreeCellRendererDelegate getRendererDelegate(JTree tree) {
        DarkTreeUI ui = DarkUIUtil.getUIOfType(tree.getUI(), DarkTreeUI.class);
        if (ui == null) {
            return null;
        }
        return DarkUIUtil.nullableCast(DarkTreeCellRendererDelegate.class, ui.getCellRenderer());
    }

    protected JComponent getBooleanRendererComponent(JTree tree) {
        DarkTreeCellRendererDelegate rend = this.getRendererDelegate(tree);
        if (rend == null) {
            return null;
        }
        return rend.getBooleanRenderer().getRendererComponent(tree);
    }

    protected JComponent getTristateRendererComponent(JTree tree) {
        DarkTreeCellRendererDelegate rend = this.getRendererDelegate(tree);
        if (rend == null) {
            return null;
        }
        return rend.getTristateRenderer().getRendererComponent();
    }
}

