/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.google.errorprone.annotations.Immutable;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.function.BiFunction;

final class AlignmentHelper {
    static final Mapper HOR_CENTER_INSIDE = (d, r) -> r.x + (r.width - d.width) / 2;
    static final Mapper HOR_LEFT_INSIDE = (d, r) -> r.x;
    static final Mapper HOR_RIGHT_INSIDE = (d, r) -> r.x + r.width - d.width;
    static final Mapper VERT_CENTER_INSIDE = (d, r) -> r.y + (r.height - d.height) / 2;
    static final Mapper VERT_TOP_INSIDE = (d, r) -> r.y;
    static final Mapper VERT_BOTTOM_INSIDE = (d, r) -> r.y + r.height - d.height;
    static final Mapper HOR_CENTER_OUTSIDE = HOR_CENTER_INSIDE;
    static final Mapper HOR_LEFT_OUTSIDE = (d, r) -> r.x - d.width;
    static final Mapper HOR_RIGHT_OUTSIDE = (d, r) -> r.x + r.width;
    static final Mapper VERT_CENTER_OUTSIDE = VERT_CENTER_INSIDE;
    static final Mapper VERT_TOP_OUTSIDE = (d, r) -> r.y - d.height;
    static final Mapper VERT_BOTTOM_OUTSIDE = (d, r) -> r.y + r.height;

    AlignmentHelper() {
    }

    static AlignFunction align(Mapper mapperX, Mapper mapperY) {
        return (d, p) -> new Point((Integer)mapperX.apply(d, p), (Integer)mapperY.apply(d, p));
    }

    private static interface Mapper
    extends BiFunction<Dimension, Rectangle, Integer> {
    }

    @Immutable
    static interface AlignFunction
    extends BiFunction<Dimension, Rectangle, Point> {
    }
}

