/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.redirects;

import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RetroFuturaBootstrap;
import com.mumfrey.liteloader.launch.InjectionStrategy;
import cpw.mods.fml.common.fakelwjgl3ify.SafeRuntimeExit;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.jar.JarFile;

public abstract class LiteLoaderClassPathUtilities {
    private static Field ucp = null;
    private static Field classPathURLs = null;
    private static Field classPathPath = null;
    private static Field classPathLoaderMap = null;
    private static Field classPathLoaderList = null;
    private static boolean canInject;
    private static boolean canTerminate;
    private static final MethodHandle rfg$addURL;

    public static void injectIntoClassPath(URLClassLoader classLoader, URL url, InjectionStrategy strategy) {
        LiteLoaderClassPathUtilities.addURL(classLoader, url);
    }

    public static void injectIntoClassPath(URLClassLoader classLoader, URL url) {
        LiteLoaderClassPathUtilities.addURL(classLoader, url);
    }

    public static void injectIntoClassPath(URLClassLoader classLoader, URL url, URL above) {
        LiteLoaderClassPathUtilities.addURL(classLoader, url);
    }

    public static void injectIntoClassPath(URLClassLoader classLoader, URL url, String above) {
        LiteLoaderClassPathUtilities.addURL(classLoader, url);
    }

    public static void addURL(URLClassLoader classLoader, URL url) {
        if (classLoader instanceof ExtensibleClassLoader) {
            ((ExtensibleClassLoader)classLoader).addURL(url);
        } else {
            try {
                rfg$addURL.invokeExact(classLoader, url);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean isJarOnClassPath(File jarFile) {
        try {
            URL[] classPath;
            String jarURL = jarFile.toURI().toURL().toString();
            for (URL classPathEntry : classPath = RetroFuturaBootstrap.API.compatClassLoader().getURLs()) {
                if (!classPathEntry.toString().equals(jarURL)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return false;
    }

    public static File getPathToResource(Class<?> contextClass, String resource) {
        URL res = contextClass.getResource(resource);
        if (res == null) {
            return null;
        }
        boolean returnParent = true;
        String jarPath = res.toString();
        if (jarPath.startsWith("jar:") && jarPath.indexOf(33) > -1) {
            jarPath = jarPath.substring(4, jarPath.indexOf(33));
            returnParent = false;
        }
        if (jarPath.startsWith("file:")) {
            try {
                File targetFile = new File(new URI(jarPath));
                return returnParent ? targetFile.getParentFile() : targetFile;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean deleteClassPathJarContaining(Class<?> contextClass, String resource) {
        return false;
    }

    public static boolean deleteClassPathJar(String jarFileName) {
        return false;
    }

    public static void terminateRuntime(int status) {
        if (!canTerminate) {
            throw new IllegalStateException();
        }
        SafeRuntimeExit.exitRuntime(status);
    }

    private static JarFile getJarFromClassLoader(URLClassLoader classLoader, String fileName, boolean removeFromClassPath) {
        try {
            URL[] urls;
            for (URL url : urls = classLoader.getURLs()) {
                URI uri = url.toURI();
                if (!uri.getPath().endsWith(fileName)) continue;
                File f = Paths.get(uri).toFile();
                return new JarFile(f, false, 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    static {
        try {
            Class<URLClassLoader> uclClass = URLClassLoader.class;
            Method addURL = uclClass.getDeclaredMethod("addURL", URL.class);
            addURL.setAccessible(true);
            rfg$addURL = MethodHandles.lookup().unreflect(addURL);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

