/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.util.glu;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.stb.STBImageResize;
import org.lwjgl.system.MemoryUtil;
import org.lwjglx.util.glu.PixelStoreState;
import org.lwjglx.util.glu.Util;

public class MipMap
extends Util {
    private static final ThreadLocal<PixelStoreState> pixelStoreState = new ThreadLocal<PixelStoreState>(){

        @Override
        protected PixelStoreState initialValue() {
            return new PixelStoreState();
        }
    };

    public static int gluBuild2DMipmaps(int target, int components, int width, int height, int format, int type, ByteBuffer data) {
        int h;
        if (width < 1 || height < 1) {
            return 100901;
        }
        int bpp = MipMap.bytesPerPixel(format, type);
        if (bpp == 0) {
            return 100900;
        }
        int maxSize = MipMap.glGetIntegerv(3379);
        int w = MipMap.nearestPower(width);
        if (w > maxSize) {
            w = maxSize;
        }
        if ((h = MipMap.nearestPower(height)) > maxSize) {
            h = maxSize;
        }
        PixelStoreState pss = pixelStoreState.get();
        pss.load();
        GL11.glPixelStorei((int)3330, (int)0);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3331, (int)0);
        GL11.glPixelStorei((int)3332, (int)0);
        int retVal = 0;
        ByteBuffer image = MemoryUtil.memAlloc((int)((w + 4) * h * bpp));
        ByteBuffer newImage = MemoryUtil.memAlloc((int)((w + 4) * h * bpp));
        if (w != width || h != height) {
            int error = MipMap.gluScaleImage(format, width, height, type, data, w, h, type, image);
            if (error != 0) {
                retVal = error;
            }
        } else {
            MemoryUtil.memCopy((ByteBuffer)data, (ByteBuffer)image);
        }
        int level = 0;
        while (retVal == 0) {
            int newH;
            GL11.glTexImage2D((int)target, (int)level, (int)components, (int)w, (int)h, (int)0, (int)format, (int)type, (ByteBuffer)image);
            if (w == 1 && h == 1) break;
            int newW = w < 2 ? 1 : w >> 1;
            int error = MipMap.gluScaleImage(format, w, h, type, image, newW, newH = h < 2 ? 1 : h >> 1, type, newImage);
            if (error != 0) {
                retVal = error;
                break;
            }
            ByteBuffer oldImage = image;
            image = newImage;
            newImage = oldImage;
            w = newW;
            h = newH;
            ++level;
        }
        pss.save();
        MemoryUtil.memFree((Buffer)image);
        MemoryUtil.memFree((Buffer)newImage);
        return retVal;
    }

    public static int gluScaleImage(int format, int widthIn, int heightIn, int typein, ByteBuffer dataIn, int widthOut, int heightOut, int typeOut, ByteBuffer dataOut) {
        int components = MipMap.compPerPix(format);
        int alphaIdx = MipMap.formatAlphaIndex(format);
        if (components == -1) {
            return 100900;
        }
        int strideIn = widthIn * components;
        int strideOut = widthOut * components;
        if (typein != typeOut) {
            return 100900;
        }
        switch (typein) {
            case 5121: {
                if (STBImageResize.stbir_resize_uint8_srgb((ByteBuffer)dataIn, (int)widthIn, (int)heightIn, (int)strideIn, (ByteBuffer)dataOut, (int)widthOut, (int)heightOut, (int)strideOut, (int)components, (int)alphaIdx, (int)0)) break;
                throw new RuntimeException("Couldn't resize image with stbir");
            }
            case 5126: {
                if (STBImageResize.stbir_resize_float((FloatBuffer)dataIn.asFloatBuffer(), (int)widthIn, (int)heightIn, (int)(strideIn * 4), (FloatBuffer)dataOut.asFloatBuffer(), (int)widthOut, (int)heightOut, (int)(strideOut * 4), (int)components)) break;
                throw new RuntimeException("Couldn't resize image with stbir");
            }
            default: {
                return 1280;
            }
        }
        return 0;
    }
}

