/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.BarnardsSystem.planets.barnardaC.world.feature;

import galaxyspace.BarnardsSystem.BRBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenBarnardaCTree
extends WorldGenAbstractTree {
    private final int minTreeHeight;
    private final int randomTreeHeight;
    private final boolean vinesGrow;
    private final Block wood;
    private final Block leaves;
    private final int metaWood;
    private int metaLeaves;
    private final int type;
    private boolean isFruitTree = false;

    public WorldGenBarnardaCTree(int type, Block wood, Block leaves, int metaWood, int metaLeaves, boolean doBlockNotify, int minTreeHeight, int randomTreeHeight, boolean vinesGrow) {
        super(doBlockNotify);
        this.wood = wood;
        this.leaves = leaves;
        this.metaWood = metaWood;
        this.metaLeaves = metaLeaves;
        this.minTreeHeight = minTreeHeight;
        this.randomTreeHeight = randomTreeHeight;
        this.vinesGrow = vinesGrow;
        this.type = type;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(this.randomTreeHeight) + this.minTreeHeight;
        boolean flag = true;
        if (this.isFruitTree) {
            this.metaLeaves = rand.nextInt(4);
        }
        if (y < 1 || y + height > 255) {
            return false;
        }
        for (int testY = y; testY <= y + 1 + height; ++testY) {
            int size = 1;
            if (testY == y) {
                size = 0;
            }
            if (testY >= y + 1 + height - 2) {
                size = 2;
            }
            for (int testX = x - size; testX <= x + size && flag; ++testX) {
                for (int testZ = z - size; testZ <= z + size && flag; ++testZ) {
                    if (testY >= 0 && testY < 256) {
                        if (this.isReplaceable(world, testX, testY, testZ)) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        Block soilBlock = world.func_147439_a(x, y - 1, z);
        boolean isSoil = soilBlock.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)BRBlocks.BarnardaCSapling);
        if (isSoil && y < 256 - height - 1) {
            soilBlock.onPlantGrow(world, x, y - 1, z, x, y, z);
            for (int dY = 0; dY < height; ++dY) {
                Block block = world.func_147439_a(x, y + dY, z);
                if (!block.isAir((IBlockAccess)world, x, y + dY, z) && !block.isLeaves((IBlockAccess)world, x, y + dY, z)) continue;
                if (world.func_147439_a(x, y - 1, z) == BRBlocks.BarnardaCGrass || world.func_147439_a(x, y - 1, z) == BRBlocks.BarnardaCDirt) {
                    this.variants(world, x, y, z);
                }
                if (!this.vinesGrow || dY <= 0) continue;
                if (rand.nextInt(3) > 0 && world.func_147437_c(x - 1, y + dY, z)) {
                    this.func_150516_a(world, x - 1, y + dY, z, Blocks.field_150395_bd, 8);
                }
                if (rand.nextInt(3) > 0 && world.func_147437_c(x + 1, y + dY, z)) {
                    this.func_150516_a(world, x + 1, y + dY, z, Blocks.field_150395_bd, 2);
                }
                if (rand.nextInt(3) > 0 && world.func_147437_c(x, y + dY, z - 1)) {
                    this.func_150516_a(world, x, y + dY, z - 1, Blocks.field_150395_bd, 1);
                }
                if (rand.nextInt(3) <= 0 || !world.func_147437_c(x, y + dY, z + 1)) continue;
                this.func_150516_a(world, x, y + dY, z + 1, Blocks.field_150395_bd, 4);
            }
            if (this.vinesGrow) {
                for (int vineY = y - 3 + height; vineY <= y + height; ++vineY) {
                    int dXZ = 2 - (vineY - (y + height)) / 2;
                    for (int vineX = x - dXZ; vineX <= x + dXZ; ++vineX) {
                        for (int vineZ = z - dXZ; vineZ <= z + dXZ; ++vineZ) {
                            if (!world.func_147439_a(vineX, vineY, vineZ).isLeaves((IBlockAccess)world, vineX, vineY, vineZ)) continue;
                            if (rand.nextInt(4) == 0 && world.func_147439_a(vineX - 1, vineY, vineZ).isAir((IBlockAccess)world, vineX - 1, vineY, vineZ)) {
                                this.growVines(world, vineX - 1, vineY, vineZ, 8);
                            }
                            if (rand.nextInt(4) == 0 && world.func_147439_a(vineX + 1, vineY, vineZ).isAir((IBlockAccess)world, vineX + 1, vineY, vineZ)) {
                                this.growVines(world, vineX + 1, vineY, vineZ, 2);
                            }
                            if (rand.nextInt(4) == 0 && world.func_147439_a(vineX, vineY, vineZ - 1).isAir((IBlockAccess)world, vineX, vineY, vineZ - 1)) {
                                this.growVines(world, vineX, vineY, vineZ - 1, 1);
                            }
                            if (rand.nextInt(4) != 0 || !world.func_147439_a(vineX, vineY, vineZ + 1).isAir((IBlockAccess)world, vineX, vineY, vineZ + 1)) continue;
                            this.growVines(world, vineX, vineY, vineZ + 1, 4);
                        }
                    }
                }
                if (rand.nextInt(5) == 0 && height > 5) {
                    for (int i = 0; i < 2; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            if (rand.nextInt(4 - i) != 0) continue;
                            int k = rand.nextInt(3);
                            this.func_150516_a(world, x + Direction.field_71583_a[Direction.field_71580_e[j]], y + height - 5 + i, z + Direction.field_71581_b[Direction.field_71580_e[j]], Blocks.field_150375_by, k << 2 | j);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void growVines(World world, int x, int y, int z, int flag) {
        this.func_150516_a(world, x, y, z, Blocks.field_150395_bd, flag);
        for (int i = 4; !world.func_147439_a(x, --y, z).isAir((IBlockAccess)world, x, y, z) && i > 0; --i) {
            this.func_150516_a(world, x, y, z, Blocks.field_150395_bd, flag);
        }
    }

    private void variants(World world, int x, int y, int z) {
        if (this.type == 1) {
            this.func_150516_a(world, x -= 4, y + 3, (z -= 3) + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x, y + 4, z + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x, y + 4, z + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x, y + 4, z + 5, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x, y + 5, z + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 1, y + 3, z + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 1, y + 3, z + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 1, y + 4, z + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 1, y + 5, z + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 1, y + 5, z + 5, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 1, y + 6, z + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 2, y + 3, z + 2, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 2, y + 3, z + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 2, y + 4, z + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 2, y + 4, z + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 2, y + 5, z + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 4, y + 3, z + 2, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 4, y + 3, z + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 4, y + 4, z, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 4, y + 4, z + 1, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 4, y + 4, z + 2, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 5, y + 2, z + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 5, y + 3, z + 1, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 5, y + 3, z + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 5, y + 4, z, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 5, y + 4, z + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 5, y + 5, z + 1, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 5, y + 5, z + 2, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 6, y + 3, z + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 6, y + 4, z + 1, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 6, y + 4, z + 2, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 1, y + 4, z + 3, this.wood, this.metaWood);
            this.func_150516_a(world, x + 1, y + 5, z + 4, this.wood, this.metaWood);
            this.func_150516_a(world, x + 2, y + 3, z + 3, this.wood, this.metaWood);
            this.func_150516_a(world, x + 3, y + 2, z + 3, this.wood, this.metaWood);
            this.func_150516_a(world, x + 3, y + 3, z + 3, this.wood, this.metaWood);
            this.func_150516_a(world, x + 4, y, z + 3, this.wood, this.metaWood);
            this.func_150516_a(world, x + 4, y + 1, z + 3, this.wood, this.metaWood);
            this.func_150516_a(world, x + 4, y + 2, z + 3, this.wood, this.metaWood);
            this.func_150516_a(world, x + 5, y + 3, z + 3, this.wood, this.metaWood);
            this.func_150516_a(world, x + 5, y + 4, z + 1, this.wood, this.metaWood);
            this.func_150516_a(world, x + 5, y + 4, z + 2, this.wood, this.metaWood);
        }
        if (this.type == 2) {
            this.func_150516_a(world, x -= 2, y + 6, (z -= 2) + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 1, y + 1, z + 1, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 1, y + 2, z + 2, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 1, y + 6, z + 2, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 1, y + 6, z + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 1, y + 7, z + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 1, y + 7, z + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 2, y + 3, z, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 2, y + 3, z + 1, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 2, y + 4, z + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 2, y + 6, z + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 3, y + 2, z + 1, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 3, y + 3, z + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 3, y + 4, z + 4, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 4, y + 4, z + 3, this.leaves, this.metaLeaves);
            this.func_150516_a(world, x + 1, y + 1, z + 2, this.wood, this.metaWood);
            this.func_150516_a(world, x + 1, y + 2, z + 1, this.wood, this.metaWood);
            this.func_150516_a(world, x + 1, y + 6, z + 3, this.wood, this.metaWood);
            this.func_150516_a(world, x + 2, y, z + 2, this.wood, this.metaWood);
            this.func_150516_a(world, x + 2, y + 2, z + 1, this.wood, this.metaWood);
            this.func_150516_a(world, x + 2, y + 5, z + 3, this.wood, this.metaWood);
            this.func_150516_a(world, x + 3, y + 3, z + 1, this.wood, this.metaWood);
            this.func_150516_a(world, x + 3, y + 3, z + 2, this.wood, this.metaWood);
            this.func_150516_a(world, x + 3, y + 4, z + 3, this.wood, this.metaWood);
        }
    }
}

