/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.moons.europa.dimension;

import galaxyspace.SolarSystem.moons.europa.world.BiomeDecoratorEuropaOre;
import galaxyspace.core.dimension.ChunkProviderSpaceCraters;
import galaxyspace.core.entity.mob.EntityEvolvedColdBlaze;
import galaxyspace.core.entity.mob.EntityEvolvedEnderman;
import galaxyspace.core.register.GSBlocks;
import galaxyspace.core.world.GSBiomeGenBase;
import java.util.Collections;
import java.util.List;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class ChunkProviderEuropa
extends ChunkProviderSpaceCraters {
    private final NoiseModule noiseGen4;

    @Override
    protected List<MapGenBaseMeta> getWorldGenerators() {
        return Collections.emptyList();
    }

    public ChunkProviderEuropa(World world, long seed, boolean mapFeaturesEnabled) {
        super(world, seed, mapFeaturesEnabled);
        this.field_73231_z = this.getBiomesForGeneration();
        this.noiseGen4 = new Gradient(this.field_73220_k.nextLong(), 1, 0.25f);
    }

    @Override
    protected BiomeDecoratorSpace getBiomeGenerator() {
        return new BiomeDecoratorEuropaOre();
    }

    @Override
    protected BiomeGenBase[] getBiomesForGeneration() {
        return new BiomeGenBase[]{GSBiomeGenBase.SPACE};
    }

    @Override
    public int getCraterProbability() {
        return 300;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    @Override
    public double getHeightModifier() {
        return 8.0;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getMonsters() {
        BiomeGenBase.SpawnListEntry skele = new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry creeper = new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry spider = new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry enderman = new BiomeGenBase.SpawnListEntry(EntityEvolvedEnderman.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry blaze = new BiomeGenBase.SpawnListEntry(EntityEvolvedColdBlaze.class, 100, 4, 4);
        return new BiomeGenBase.SpawnListEntry[]{skele, creeper, spider, enderman, blaze};
    }

    @Override
    public double getMountainHeightModifier() {
        return 30.0;
    }

    @Override
    protected int getSeaLevel() {
        return 70;
    }

    @Override
    public double getSmallFeatureHeightModifier() {
        return 5.0;
    }

    @Override
    public double getValleyHeightModifier() {
        return 0.0;
    }

    @Override
    public void onChunkProvide(int cX, int cZ, Block[] blocks, byte[] metadata) {
        this.generateTerrain(cX, cZ, blocks, metadata);
        this.field_73231_z = this.field_73230_p.func_72959_q().func_76933_b(this.field_73231_z, cX * 16, cZ * 16, 16, 16);
        this.func_147422_a(cX, cZ, blocks, metadata, this.field_73231_z);
    }

    @Override
    public void onPopulate(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
    }

    @Override
    public void func_147422_a(int chunkX, int chunkZ, Block[] arrayOfIDs, byte[] arrayOfMeta, BiomeGenBase[] biomes) {
        this.noiseGen4.setFrequency(0.0625f);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                GSBiomeGenBase biomegenbase = (GSBiomeGenBase)biomes[x + z * 16];
                int noise = (int)((double)this.noiseGen4.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) / 3.0 + 3.0 + this.field_73220_k.nextDouble() * 0.25);
                int var10 = -1;
                Block topBlock = this.enableBiomeGenBaseBlock() ? biomegenbase.field_76752_A : this.getGrassBlock().getBlock();
                byte topMeta = this.enableBiomeGenBaseBlock() ? biomegenbase.topMeta : this.getGrassBlock().getMetadata();
                Block fillerBlock = this.enableBiomeGenBaseBlock() ? biomegenbase.field_76753_B : this.getDirtBlock().getBlock();
                byte fillerMeta = this.enableBiomeGenBaseBlock() ? biomegenbase.fillerMeta : this.getDirtBlock().getMetadata();
                for (int y = 127; y >= 0; --y) {
                    int index = this.getIndex(x, y, z);
                    if (y <= 0 + this.field_73220_k.nextInt(5)) {
                        arrayOfIDs[index] = Blocks.field_150357_h;
                        continue;
                    }
                    if (y == 5 || y == 6 + this.field_73220_k.nextInt(3)) {
                        arrayOfIDs[index] = Blocks.field_150403_cj;
                        continue;
                    }
                    if (y <= this.getSeaLevel() - 6 && y >= this.getSeaLevel() - 16 || y <= this.getSeaLevel() - 6 && y >= this.getSeaLevel() - 16 + this.field_73220_k.nextInt(3)) {
                        arrayOfIDs[index] = GSBlocks.EuropaBlocks;
                        arrayOfMeta[index] = 1;
                        continue;
                    }
                    Block block = arrayOfIDs[index];
                    if (Blocks.field_150350_a == block) {
                        var10 = -1;
                        continue;
                    }
                    if (block != this.getStoneBlock().getBlock()) continue;
                    if (var10 == -1) {
                        if (noise <= 0) {
                            topBlock = Blocks.field_150350_a;
                            topMeta = 0;
                            if (biomegenbase.stoneBlock != null) {
                                fillerBlock = biomegenbase.stoneBlock;
                                fillerMeta = biomegenbase.stoneMeta;
                            } else {
                                fillerBlock = this.getStoneBlock().getBlock();
                                fillerMeta = this.getStoneBlock().getMetadata();
                            }
                        } else if (y >= 56 && y <= 41) {
                            if (this.enableBiomeGenBaseBlock()) {
                                topBlock = biomegenbase.field_76752_A;
                                topMeta = biomegenbase.topMeta;
                                topBlock = biomegenbase.field_76753_B;
                                topMeta = biomegenbase.fillerMeta;
                            } else {
                                topBlock = this.getGrassBlock().getBlock();
                                topMeta = this.getGrassBlock().getMetadata();
                                topBlock = this.getDirtBlock().getBlock();
                                topMeta = this.getDirtBlock().getMetadata();
                            }
                        }
                        var10 = noise;
                        if (y >= 39) {
                            arrayOfIDs[index] = topBlock;
                            arrayOfMeta[index] = topMeta;
                            continue;
                        }
                        arrayOfIDs[index] = fillerBlock;
                        arrayOfMeta[index] = fillerMeta;
                        continue;
                    }
                    if (var10 <= 0) continue;
                    --var10;
                    arrayOfIDs[index] = fillerBlock;
                    arrayOfMeta[index] = fillerMeta;
                }
            }
        }
    }

    private int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getWaterCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    @Override
    protected BlockMetaPair getGrassBlock() {
        return new BlockMetaPair(GSBlocks.EuropaBlocks, 0);
    }

    @Override
    protected BlockMetaPair getDirtBlock() {
        return new BlockMetaPair(GSBlocks.EuropaBlocks, 1);
    }

    @Override
    protected BlockMetaPair getStoneBlock() {
        return new BlockMetaPair(Blocks.field_150355_j, 0);
    }

    @Override
    protected boolean enableBiomeGenBaseBlock() {
        return false;
    }

    @Override
    public String func_73148_d() {
        return "EuropaLevelSource";
    }
}

