/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.kuiperbelt.dimension;

import galaxyspace.GalaxySpace;
import galaxyspace.SolarSystem.planets.kuiperbelt.dimension.WorldProviderKuiper;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.TeleportTypeAsteroids;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;

public class TeleportTypeKuiper
extends TeleportTypeAsteroids {
    public Vector3 getPlayerSpawnLocation(WorldServer world, EntityPlayerMP player) {
        if (player == null) {
            GalaxySpace.error("Null player when teleporting to Asteroids!");
            return new Vector3(0.0, 310.0, 0.0);
        }
        GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)player);
        int x = MathHelper.func_76128_c((double)stats.coordsTeleportedFromX);
        int z = MathHelper.func_76128_c((double)stats.coordsTeleportedFromZ);
        int attemptCount = 0;
        this.preGenChunks((World)world, x >> 4, z >> 4);
        do {
            BlockVec3 bv3 = null;
            if (world.field_73011_w instanceof WorldProviderKuiper) {
                bv3 = ((WorldProviderKuiper)world.field_73011_w).getClosestAsteroidXZ(x, 0, z);
            }
            if (bv3 == null) continue;
            if (bv3.distanceSquared(new BlockVec3(x, 128, z)) > 25600) break;
            if (ConfigManagerCore.enableDebug) {
                GalaxySpace.info("Testing asteroid at x" + bv3.x + " y" + bv3.y + " z" + bv3.z);
            }
            this.loadChunksAround(bv3.x, bv3.z, 2, world.field_73059_b);
            this.loadChunksAround(bv3.x, bv3.z, -3, world.field_73059_b);
            if (this.goodAsteroidEntry((World)world, bv3.x, bv3.y, bv3.z)) {
                return new Vector3((double)bv3.x, 310.0, (double)bv3.z);
            }
            if (this.goodAsteroidEntry((World)world, bv3.x + 2, bv3.y, bv3.z + 2)) {
                return new Vector3((double)(bv3.x + 2), 310.0, (double)(bv3.z + 2));
            }
            if (this.goodAsteroidEntry((World)world, bv3.x + 2, bv3.y, bv3.z - 2)) {
                return new Vector3((double)(bv3.x + 2), 310.0, (double)(bv3.z - 2));
            }
            if (this.goodAsteroidEntry((World)world, bv3.x - 2, bv3.y, bv3.z - 2)) {
                return new Vector3((double)(bv3.x - 2), 310.0, (double)(bv3.z - 2));
            }
            if (this.goodAsteroidEntry((World)world, bv3.x - 2, bv3.y, bv3.z + 2)) {
                return new Vector3((double)(bv3.x - 2), 310.0, (double)(bv3.z + 2));
            }
            if (ConfigManagerCore.enableDebug) {
                GalaxySpace.info("Removing drilled out asteroid at x" + bv3.x + " z" + bv3.z);
            }
            ((WorldProviderKuiper)world.field_73011_w).removeAsteroid(bv3.x, bv3.y, bv3.z);
        } while (++attemptCount < 5);
        GalaxySpace.info("Failed to find good large asteroid landing spot! Falling back to making a small one.");
        this.makeSmallLandingSpot((World)world, x, z);
        return new Vector3((double)x, 310.0, (double)z);
    }

    private boolean goodAsteroidEntry(World world, int x, int yorig, int z) {
        for (int k = 208; k > 48; --k) {
            if (world.func_147437_c(x, k, z) || Math.abs(k - yorig) > 20) continue;
            for (int y = k + 2; y < 256; ++y) {
                if (world.func_147439_a(x, y, z) == AsteroidBlocks.blockBasic) {
                    world.func_147468_f(x, y, z);
                }
                if (world.func_147439_a(x - 1, y, z) == AsteroidBlocks.blockBasic) {
                    world.func_147468_f(x - 1, y, z);
                }
                if (world.func_147439_a(x, y, z - 1) == AsteroidBlocks.blockBasic) {
                    world.func_147468_f(x, y, z - 1);
                }
                if (world.func_147439_a(x - 1, y, z - 1) != AsteroidBlocks.blockBasic) continue;
                world.func_147468_f(x - 1, y, z - 1);
            }
            if (ConfigManagerCore.enableDebug) {
                GalaxySpace.info("Found asteroid at x" + x + " z" + z);
            }
            return true;
        }
        return false;
    }

    private void makeSmallLandingSpot(World world, int x, int z) {
        this.loadChunksAround(x, z, -1, (ChunkProviderServer)world.func_72863_F());
        for (int k = 255; k > 48; --k) {
            if (!world.func_147437_c(x, k, z)) {
                this.makePlatform(world, x, k - 1, z);
                return;
            }
            if (!world.func_147437_c(x - 1, k, z)) {
                this.makePlatform(world, x - 1, k - 1, z);
                return;
            }
            if (!world.func_147437_c(x - 1, k, z - 1)) {
                this.makePlatform(world, x - 1, k - 1, z - 1);
                return;
            }
            if (world.func_147437_c(x, k, z - 1)) continue;
            this.makePlatform(world, x, k - 1, z - 1);
            return;
        }
        this.makePlatform(world, x, 48 + world.field_73012_v.nextInt(128), z);
    }

    private void loadChunksAround(int x, int z, int i, ChunkProviderServer cp) {
        cp.func_73158_c(x >> 4, z >> 4);
        if (x + i >> 4 != x >> 4) {
            cp.func_73158_c(x + i >> 4, z >> 4);
            if (z + i >> 4 != z >> 4) {
                cp.func_73158_c(x >> 4, z + i >> 4);
                cp.func_73158_c(x + i >> 4, z + i >> 4);
            }
        } else if (z + i >> 4 != z >> 4) {
            cp.func_73158_c(x >> 4, z + i >> 4);
        }
    }

    private void makePlatform(World world, int x, int y, int z) {
        int zz;
        int xx;
        for (xx = -3; xx < 3; ++xx) {
            for (zz = -3; zz < 3; ++zz) {
                if (xx == -3 && (zz == -3 || zz == 2) || xx == 2 && (zz == -3 || zz == 2)) continue;
                this.doBlock(world, x + xx, y, z + zz);
            }
        }
        for (xx = -2; xx < 2; ++xx) {
            for (zz = -2; zz < 2; ++zz) {
                this.doBlock(world, x + xx, y - 1, z + zz);
            }
        }
        this.doBlock(world, x - 1, y - 2, z - 1);
        this.doBlock(world, x - 1, y - 2, z);
        this.doBlock(world, x, y - 2, z);
        this.doBlock(world, x, y - 2, z - 1);
    }

    private void doBlock(World world, int x, int y, int z) {
        int meta = (int)(world.field_73012_v.nextFloat() * 1.5f);
        if (world.func_147437_c(x, y, z)) {
            world.func_147465_d(x, y, z, AsteroidBlocks.blockBasic, meta, 2);
        }
    }

    private void preGenChunks(World w, int cx, int cz) {
        this.preGenChunk(w, cx, cz);
        for (int r = 1; r < 3; ++r) {
            int xmin = cx - r;
            int xmax = cx + r;
            int zmin = cz - r;
            int zmax = cz + r;
            for (int i = -r; i < r; ++i) {
                this.preGenChunk(w, xmin, cz + i);
                this.preGenChunk(w, xmax, cz - i);
                this.preGenChunk(w, cx - i, zmin);
                this.preGenChunk(w, cx + i, zmax);
            }
        }
    }

    private void preGenChunk(World w, int chunkX, int chunkZ) {
        w.func_72964_e(chunkX, chunkZ);
    }
}

