/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.pluto.world.dungeon;

import galaxyspace.core.register.GSBlocks;
import galaxyspace.core.tile.chest.TileEntityTreasureChestT8;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonBoundingBox;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonRoom;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.MapGenDungeon;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class RoomTreasurePluto
extends DungeonRoom {
    private int sizeX;
    private int sizeY;
    private int sizeZ;
    private final Set<ChunkCoordinates> chests = new HashSet<ChunkCoordinates>();

    public RoomTreasurePluto(MapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            Random rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = rand.nextInt(6) + 7;
            this.sizeY = rand.nextInt(2) + 8;
            this.sizeZ = rand.nextInt(6) + 7;
        }
    }

    public void generate(Block[] chunk, byte[] meta, int cx, int cz) {
        for (int x = this.posX - 1; x <= this.posX + this.sizeX; ++x) {
            for (int z = this.posZ - 1; z <= this.posZ + this.sizeZ; ++z) {
                for (int y = this.posY - 1; y <= this.posY + this.sizeY; ++y) {
                    if (x == this.posX - 1 || x == this.posX + this.sizeX || y == this.posY - 1 || y == this.posY + this.sizeY || z == this.posZ - 1 || z == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, x, y, z, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        continue;
                    }
                    if (!(x != this.posX && x != this.posX + this.sizeX - 1 || z != this.posZ && z != this.posZ + this.sizeZ - 1)) {
                        this.placeBlock(chunk, meta, x, y, z, cx, cz, GSBlocks.PlutoGlowStone, 0);
                        continue;
                    }
                    this.placeBlock(chunk, meta, x, y, z, cx, cz, Blocks.field_150350_a, 0);
                }
            }
        }
        int hx = (this.posX + this.posX + this.sizeX) / 2;
        int hz = (this.posZ + this.posZ + this.sizeZ) / 2;
        if (this.placeBlock(chunk, meta, hx, this.posY, hz, cx, cz, (Block)GSBlocks.PlutoTChestT8, 0)) {
            this.chests.add(new ChunkCoordinates(hx, this.posY, hz));
        }
    }

    public DungeonBoundingBox getBoundingBox() {
        return new DungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    protected DungeonRoom makeRoom(MapGenDungeon dungeon, int x, int y, int z, ForgeDirection dir) {
        return new RoomTreasurePluto(dungeon, x, y, z, dir);
    }

    protected void handleTileEntities(Random rand) {
        if (!this.chests.isEmpty()) {
            HashSet<ChunkCoordinates> removeList = new HashSet<ChunkCoordinates>();
            for (ChunkCoordinates coords : this.chests) {
                this.worldObj.func_147465_d(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, (Block)GSBlocks.PlutoTChestT8, 1, 0);
                this.worldObj.func_147455_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, (TileEntity)new TileEntityTreasureChestT8());
                removeList.add(coords);
            }
            this.chests.removeAll(removeList);
        }
    }
}

