/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.venus.dimension.sky;

import galaxyspace.core.render.GSResources;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class WeatherProviderVenus
extends IRenderHandler {
    private float[] rainXCoords;
    private float[] rainZCoords;
    private int rendererUpdateCount;
    private final Random random = new Random();

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        ++this.rendererUpdateCount;
        this.renderNormalWeather(partialTicks, mc);
    }

    private void renderNormalWeather(float partialTicks, Minecraft mc) {
        float rainStrength = mc.field_71441_e.func_72867_j(partialTicks);
        if (rainStrength > 0.0f) {
            mc.field_71460_t.func_78463_b((double)partialTicks);
            this.initializeRainCoords();
            EntityLivingBase entitylivingbase = mc.field_71451_h;
            WorldClient worldclient = mc.field_71441_e;
            int pX = MathHelper.func_76128_c((double)entitylivingbase.field_70165_t);
            int pY = MathHelper.func_76128_c((double)entitylivingbase.field_70163_u);
            int pZ = MathHelper.func_76128_c((double)entitylivingbase.field_70161_v);
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glDisable((int)2884);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            double iX = entitylivingbase.field_70142_S + (entitylivingbase.field_70165_t - entitylivingbase.field_70142_S) * (double)partialTicks;
            double iY = entitylivingbase.field_70137_T + (entitylivingbase.field_70163_u - entitylivingbase.field_70137_T) * (double)partialTicks;
            double iZ = entitylivingbase.field_70136_U + (entitylivingbase.field_70161_v - entitylivingbase.field_70136_U) * (double)partialTicks;
            int floorY = MathHelper.func_76128_c((double)iY);
            int range = 5;
            if (mc.field_71474_y.field_74347_j) {
                range = 10;
            }
            int b1 = -1;
            float tick = (float)this.rendererUpdateCount + partialTicks;
            if (mc.field_71474_y.field_74347_j) {
                range = 10;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int z = pZ - range; z <= pZ + range; ++z) {
                for (int x = pX - range; x <= pX + range; ++x) {
                    float downwardsMotion;
                    int y;
                    int index = (z - pZ + 16) * 32 + x - pX + 16;
                    float rainX = this.rainXCoords[index] * 0.5f;
                    float rainZ = this.rainZCoords[index] * 0.5f;
                    BiomeGenBase biome = worldclient.func_72807_a(x, z);
                    if (!biome.func_76738_d() && !biome.func_76746_c()) continue;
                    int precipitationHeight = worldclient.func_72874_g(x, z);
                    int minY = pY - range;
                    int maxY = pY + range;
                    if (minY < precipitationHeight) {
                        minY = precipitationHeight;
                    }
                    if (maxY < precipitationHeight) {
                        maxY = precipitationHeight;
                    }
                    if ((y = precipitationHeight) < floorY) {
                        y = floorY;
                    }
                    if (minY == maxY) continue;
                    this.random.setSeed(x * x * 3121 + x * 45238971 ^ z * z * 418711 + z * 13761);
                    float temperature = biome.func_150564_a(x, minY, z);
                    if (worldclient.func_72959_q().func_76939_a(temperature, precipitationHeight) >= 0.15f) {
                        if (b1 != 0) {
                            if (b1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            b1 = 0;
                            mc.func_110434_K().func_110577_a(GSResources.venusRainTexture);
                            tessellator.func_78382_b();
                        }
                        downwardsMotion = ((float)(this.rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + this.random.nextFloat());
                        double dX = (double)((float)x + 0.5f) - entitylivingbase.field_70165_t;
                        double dZ = (double)((float)z + 0.5f) - entitylivingbase.field_70161_v;
                        float dist = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ)) / (float)range;
                        tessellator.func_78380_c(worldclient.func_72802_i(x, y, z, 0));
                        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, ((1.0f - dist * dist) * 0.5f + 0.5f) * rainStrength);
                        tessellator.func_78373_b(-iX * 1.0, -iY * 1.0, -iZ * 1.0);
                        tessellator.func_78374_a((double)((float)x - rainX) + 0.5, (double)minY, (double)((float)z - rainZ) + 0.5, 0.0, (double)((float)minY * 0.25f + downwardsMotion));
                        tessellator.func_78374_a((double)((float)x + rainX) + 0.5, (double)minY, (double)((float)z + rainZ) + 0.5, 1.0, (double)((float)minY * 0.25f + downwardsMotion));
                        tessellator.func_78374_a((double)((float)x + rainX) + 0.5, (double)maxY, (double)((float)z + rainZ) + 0.5, 1.0, (double)((float)maxY * 0.25f + downwardsMotion));
                        tessellator.func_78374_a((double)((float)x - rainX) + 0.5, (double)maxY, (double)((float)z - rainZ) + 0.5, 0.0, (double)((float)maxY * 0.25f + downwardsMotion));
                    } else {
                        if (b1 != 1) {
                            if (b1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            b1 = 1;
                            mc.func_110434_K().func_110577_a(GSResources.snowTexture);
                            tessellator.func_78382_b();
                        }
                        downwardsMotion = ((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                        float rU = this.random.nextFloat() + tick * 0.01f * (float)this.random.nextGaussian();
                        float rV = this.random.nextFloat() + tick * (float)this.random.nextGaussian() * 0.001f;
                        double dX = (double)((float)x + 0.5f) - entitylivingbase.field_70165_t;
                        double dZ = (double)((float)z + 0.5f) - entitylivingbase.field_70161_v;
                        float dist = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ)) / (float)range;
                        tessellator.func_78380_c((worldclient.func_72802_i(x, y, z, 0) * 3 + 0xF000F0) / 4);
                        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, ((1.0f - dist * dist) * 0.3f + 0.5f) * rainStrength);
                        tessellator.func_78373_b(-iX * 1.0, -iY * 1.0, -iZ * 1.0);
                        tessellator.func_78374_a((double)((float)x - rainX) + 0.5, (double)minY, (double)((float)z - rainZ) + 0.5, (double)rU, (double)((float)minY * 0.25f + downwardsMotion + rV));
                        tessellator.func_78374_a((double)((float)x + rainX) + 0.5, (double)minY, (double)((float)z + rainZ) + 0.5, (double)(1.0f + rU), (double)((float)minY * 0.25f + downwardsMotion + rV));
                        tessellator.func_78374_a((double)((float)x + rainX) + 0.5, (double)maxY, (double)((float)z + rainZ) + 0.5, (double)(1.0f + rU), (double)((float)maxY * 0.25f + downwardsMotion + rV));
                        tessellator.func_78374_a((double)((float)x - rainX) + 0.5, (double)maxY, (double)((float)z - rainZ) + 0.5, (double)rU, (double)((float)maxY * 0.25f + downwardsMotion + rV));
                    }
                    tessellator.func_78373_b(0.0, 0.0, 0.0);
                }
            }
            if (b1 >= 0) {
                tessellator.func_78381_a();
            }
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            mc.field_71460_t.func_78483_a((double)partialTicks);
        }
    }

    private void initializeRainCoords() {
        if (this.rainXCoords == null) {
            this.rainXCoords = new float[1024];
            this.rainZCoords = new float[1024];
            for (int i = 0; i < 32; ++i) {
                for (int j = 0; j < 32; ++j) {
                    float f2 = j - 16;
                    float f3 = i - 16;
                    float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                    this.rainXCoords[i << 5 | j] = -f3 / f4;
                    this.rainZCoords[i << 5 | j] = f2 / f4;
                }
            }
        }
    }
}

