/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.GalaxySpace;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.item.IHoldableItem;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ItemRocket
extends Item
implements IHoldableItem {
    private final int tier;
    private final RocketCtor rocketCtor;
    private final EntityTieredRocket[] dummyRocket;

    public ItemRocket(int tier, RocketCtor rocketCtor) {
        this.tier = tier;
        this.rocketCtor = rocketCtor;
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77655_b("Tier" + tier + "Rocket");
        this.func_77637_a(GalaxySpace.tabItems);
        this.dummyRocket = new EntityTieredRocket[IRocketType.EnumRocketType.values().length];
        for (int i = 0; i < this.dummyRocket.length; ++i) {
            this.dummyRocket[i] = rocketCtor.construct(null, 0.0, 0.0, 0.0, IRocketType.EnumRocketType.values()[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
    }

    public EnumRarity func_77613_e(ItemStack itemIn) {
        return ClientProxyCore.galacticraftItem;
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        boolean padFound = false;
        TileEntity tile = null;
        if (world.field_72995_K) {
            return false;
        }
        float centerX = -1.0f;
        float centerY = -1.0f;
        float centerZ = -1.0f;
        for (int dX = -1; dX < 2; ++dX) {
            for (int dZ = -1; dZ < 2; ++dZ) {
                Block id = world.func_147439_a(x + dX, y, z + dZ);
                int meta = world.func_72805_g(x + dX, y, z + dZ);
                if (id != GCBlocks.landingPadFull || meta != 0) continue;
                padFound = true;
                tile = world.func_147438_o(x + dX, y, z + dZ);
                centerX = (float)(x + dX) + 0.5f;
                centerY = (float)y + 0.4f;
                centerZ = (float)(z + dZ) + 0.5f;
                break;
            }
            if (padFound) break;
        }
        if (!padFound || !(tile instanceof TileEntityLandingPad) || ((TileEntityLandingPad)tile).getDockedEntity() != null) {
            return false;
        }
        EntityTieredRocket rocket = this.rocketCtor.construct(world, centerX, centerY, centerZ, IRocketType.EnumRocketType.values()[itemstack.func_77960_j()]);
        rocket.field_70177_z += 45.0f;
        rocket.func_70107_b(rocket.field_70165_t, rocket.field_70163_u + rocket.getOnPadYOffset(), rocket.field_70161_v);
        world.func_72838_d((Entity)rocket);
        if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b("RocketFuel")) {
            rocket.fuelTank.fill(new FluidStack(GalacticraftCore.fluidFuel, itemstack.func_77978_p().func_74762_e("RocketFuel")), true);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --itemstack.field_77994_a;
            if (itemstack.field_77994_a <= 0) {
                itemstack = null;
            }
        }
        if (rocket.getType().getPreFueled()) {
            rocket.fuelTank.fill(new FluidStack(GalacticraftCore.fluidFuel, rocket.getMaxFuel()), true);
        }
        return true;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> itemList) {
        for (int i = 0; i < IRocketType.EnumRocketType.values().length; ++i) {
            itemList.add(new ItemStack(item, 1, i));
        }
    }

    public void func_77624_a(ItemStack itemIn, EntityPlayer player, List<String> toolTip, boolean advancedItemTooltips) {
        int meta = itemIn.func_77960_j();
        IRocketType.EnumRocketType type = itemIn.func_77960_j() < 10 ? IRocketType.EnumRocketType.values()[meta] : IRocketType.EnumRocketType.values()[meta - 10];
        if (!type.getTooltip().isEmpty()) {
            toolTip.add(type.getTooltip());
        }
        if (type.getPreFueled()) {
            toolTip.add(EnumChatFormatting.RED.toString() + EnumChatFormatting.ITALIC + GCCoreUtil.translate((String)"gui.creativeOnly.desc"));
        }
        if (itemIn.func_77942_o() && itemIn.func_77978_p().func_74764_b("RocketFuel")) {
            toolTip.add(GCCoreUtil.translate((String)"gui.message.fuel.name") + ": " + itemIn.func_77978_p().func_74762_e("RocketFuel") + " / " + this.dummyRocket[meta].fuelTank.getCapacity());
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + ".t" + this.tier + "Rocket";
    }

    public boolean shouldHoldLeftHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldHoldRightHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldCrouch(EntityPlayer player) {
        return true;
    }

    @FunctionalInterface
    public static interface RocketCtor {
        public EntityTieredRocket construct(World var1, double var2, double var4, double var6, IRocketType.EnumRocketType var8);
    }
}

