/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.mca.common.animation;

import galaxyspace.core.mca.common.animation.KeyFrame;
import java.util.HashMap;
import java.util.Map;

public class Channel {
    public static final byte LINEAR = 0;
    public static final byte LOOP = 1;
    public static final byte CYCLE = 2;
    public static final byte CUSTOM = 3;
    public final String name;
    public float fps;
    public int totalFrames;
    public final Map<Integer, KeyFrame> keyFrames = new HashMap<Integer, KeyFrame>();
    public byte mode = 0;

    public Channel(String name) {
        this.name = name;
        this.totalFrames = 0;
        this.initializeAllFrames();
    }

    public Channel(String name, float fps, int totalFrames, byte mode) {
        this(name);
        this.fps = fps;
        this.totalFrames = totalFrames;
        this.mode = mode;
    }

    protected void initializeAllFrames() {
    }

    public KeyFrame getPreviousRotationKeyFrameForBox(String boxName, float currentFrame) {
        int latestFramePosition = -1;
        KeyFrame latestKeyFrame = null;
        for (Map.Entry<Integer, KeyFrame> entry : this.keyFrames.entrySet()) {
            Integer key = entry.getKey();
            KeyFrame value = entry.getValue();
            if (!((float)key.intValue() <= currentFrame) || key <= latestFramePosition || !value.useBoxInRotations(boxName)) continue;
            latestFramePosition = key;
            latestKeyFrame = value;
        }
        return latestKeyFrame;
    }

    public KeyFrame getNextRotationKeyFrameForBox(String boxName, float currentFrame) {
        int nextFramePosition = -1;
        KeyFrame nextKeyFrame = null;
        for (Map.Entry<Integer, KeyFrame> entry : this.keyFrames.entrySet()) {
            Integer key = entry.getKey();
            KeyFrame value = entry.getValue();
            if (!((float)key.intValue() > currentFrame) || key >= nextFramePosition && nextFramePosition != -1 || !value.useBoxInRotations(boxName)) continue;
            nextFramePosition = key;
            nextKeyFrame = value;
        }
        return nextKeyFrame;
    }

    public KeyFrame getPreviousTranslationKeyFrameForBox(String boxName, float currentFrame) {
        int latestFramePosition = -1;
        KeyFrame latestKeyFrame = null;
        for (Map.Entry<Integer, KeyFrame> entry : this.keyFrames.entrySet()) {
            Integer key = entry.getKey();
            KeyFrame value = entry.getValue();
            if (!((float)key.intValue() <= currentFrame) || key <= latestFramePosition || !value.useBoxInTranslations(boxName)) continue;
            latestFramePosition = key;
            latestKeyFrame = value;
        }
        return latestKeyFrame;
    }

    public KeyFrame getNextTranslationKeyFrameForBox(String boxName, float currentFrame) {
        int nextFramePosition = -1;
        KeyFrame nextKeyFrame = null;
        for (Map.Entry<Integer, KeyFrame> entry : this.keyFrames.entrySet()) {
            Integer key = entry.getKey();
            KeyFrame value = entry.getValue();
            if (!((float)key.intValue() > currentFrame) || key >= nextFramePosition && nextFramePosition != -1 || !value.useBoxInTranslations(boxName)) continue;
            nextFramePosition = key;
            nextKeyFrame = value;
        }
        return nextKeyFrame;
    }

    public int getKeyFramePosition(KeyFrame keyFrame) {
        if (keyFrame != null) {
            for (Map.Entry<Integer, KeyFrame> entry : this.keyFrames.entrySet()) {
                Integer key = entry.getKey();
                KeyFrame keyframe = entry.getValue();
                if (keyframe != keyFrame) continue;
                return key;
            }
        }
        return -1;
    }

    public static boolean shouldAnimationStop() {
        return false;
    }
}

