/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.render.entity.boss;

import galaxyspace.core.entity.boss.EntitySlimeBoss;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderBossSlime
extends RenderLiving {
    private static final ResourceLocation TEXTURE = new ResourceLocation("galaxyspace", "textures/model/bossSlime.png");
    private ModelBase scaleAmount;

    public RenderBossSlime(ModelBase mainModel, ModelBase renderPassModel) {
        super(mainModel, 0.25f);
        this.scaleAmount = renderPassModel;
    }

    protected int shouldSlimeRenderPass(EntitySlimeBoss entitySlimeBoss, int pass, float partialTickTime) {
        if (entitySlimeBoss.func_82150_aj()) {
            return 0;
        }
        if (pass == 0) {
            this.func_77042_a(this.scaleAmount);
            GL11.glEnable((int)2977);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            return 1;
        }
        if (pass == 1) {
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return -1;
    }

    protected void scaleSlime(EntitySlimeBoss entitySlimeBoss, float partialTickTime) {
        float slimeSize = entitySlimeBoss.getSlimeSize();
        float squishFactor = (entitySlimeBoss.prevSquishFactor + (entitySlimeBoss.squishFactor - entitySlimeBoss.prevSquishFactor) * partialTickTime) / (slimeSize * 0.5f + 1.0f);
        float f = 1.0f / (squishFactor + 1.0f);
        GL11.glScalef((float)(f * slimeSize), (float)(1.0f / f * slimeSize), (float)(f * slimeSize));
    }

    protected void func_77041_b(EntityLivingBase entityLiving, float partialTickTime) {
        this.scaleSlime((EntitySlimeBoss)entityLiving, partialTickTime);
    }

    protected int func_77032_a(EntityLivingBase entityLiving, int pass, float partialTickTime) {
        return this.shouldSlimeRenderPass((EntitySlimeBoss)entityLiving, pass, partialTickTime);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return TEXTURE;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialTickTime) {
        BossStatus.func_82824_a((IBossDisplayData)((IBossDisplayData)entity), (boolean)false);
        super.func_76986_a(entity, x, y, z, yaw, partialTickTime);
    }
}

