/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.tile.machine;

import cpw.mods.fml.relauncher.Side;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.register.GSFluids;
import galaxyspace.core.register.GSItems;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityFuelGenerator
extends TileBaseUniversalElectricalSource
implements IFluidHandler,
IInventory,
ISidedInventory,
IConnector {
    private static final int MAX_GENERATE_GJ_PER_TICK = 190 * GSConfigCore.coefficientFuelGenerator;
    private static final int MIN_GENERATE_GJ_PER_TICK = 1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank fuelTank = new FluidTank(2000);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float heatGJperTick = 0.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    private int itemCookTime = 0;
    private ItemStack[] containingItems = new ItemStack[1];
    private int count = 0;

    public TileEntityFuelGenerator() {
        this.storage.setMaxExtract((float)(MAX_GENERATE_GJ_PER_TICK - 1));
    }

    public int getScaledFuelLevel(int i) {
        return this.fuelTank.getFluidAmount() * i / this.fuelTank.getCapacity();
    }

    public void func_145845_h() {
        if (this.heatGJperTick - 1.0f > 0.0f) {
            this.receiveEnergyGC(null, this.heatGJperTick - 1.0f, false);
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.containingItems[0] != null) {
                int used;
                FluidStack liquid;
                if (this.containingItems[0].func_77973_b() == GCItems.bucketFuel) {
                    liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[0]);
                    if (this.fuelTank.getFluid() == null || this.fuelTank.getFluid().amount + liquid.amount <= this.fuelTank.getCapacity()) {
                        this.fuelTank.fill(new FluidStack(GalacticraftCore.fluidFuel, 1000), true);
                        this.containingItems[0] = new ItemStack(Items.field_151133_ar);
                    }
                }
                if (this.containingItems[0].func_77973_b() == GCItems.fuelCanister) {
                    int originalDamage = this.containingItems[0].func_77960_j();
                    this.containingItems[0] = originalDamage + (used = this.fuelTank.fill(new FluidStack(GalacticraftCore.fluidFuel, 1001 - originalDamage), true)) == 1001 ? new ItemStack(GCItems.oilCanister, 1, 1001) : new ItemStack(GCItems.fuelCanister, 1, originalDamage + used);
                }
                if (this.containingItems[0].func_77973_b() == GSItems.BioFuelCanister) {
                    int originalDamage = this.containingItems[0].func_77960_j();
                    this.containingItems[0] = originalDamage + (used = this.fuelTank.fill(new FluidStack(GSFluids.BioFuel, 1001 - originalDamage), true)) == 1001 ? new ItemStack(GCItems.oilCanister, 1, 1001) : new ItemStack(GSItems.BioFuelCanister, 1, originalDamage + used);
                } else {
                    liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[0]);
                    if (liquid != null) {
                        int amount;
                        boolean isOil = FluidRegistry.getFluidName((FluidStack)liquid).startsWith("fuel");
                        boolean isBioFuel = FluidRegistry.getFluidName((FluidStack)liquid).startsWith("biofuel");
                        if (isOil && (this.fuelTank.getFluid() == null || this.fuelTank.getFluid().amount + liquid.amount <= this.fuelTank.getCapacity())) {
                            this.fuelTank.fill(new FluidStack(GalacticraftCore.fluidFuel, liquid.amount), true);
                            if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[0]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[0])) {
                                amount = this.containingItems[0].field_77994_a;
                                if (amount > 1) {
                                    this.fuelTank.fill(new FluidStack(GalacticraftCore.fluidFuel, (amount - 1) * 1000), true);
                                }
                                this.containingItems[0] = new ItemStack(Items.field_151133_ar, amount);
                            } else {
                                ItemStack itemStack = this.containingItems[0];
                                --itemStack.field_77994_a;
                                if (this.containingItems[0].field_77994_a == 0) {
                                    this.containingItems[0] = null;
                                }
                            }
                        }
                        if (isBioFuel && (this.fuelTank.getFluid() == null || this.fuelTank.getFluid().amount + liquid.amount <= this.fuelTank.getCapacity())) {
                            this.fuelTank.fill(new FluidStack(GSFluids.BioFuel, liquid.amount), true);
                            if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[0]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[0])) {
                                amount = this.containingItems[0].field_77994_a;
                                if (amount > 1) {
                                    this.fuelTank.fill(new FluidStack(GSFluids.BioFuel, (amount - 1) * 1000), true);
                                }
                                this.containingItems[0] = new ItemStack(Items.field_151133_ar, amount);
                            } else {
                                ItemStack itemStack2 = this.containingItems[0];
                                --itemStack2.field_77994_a;
                                if (this.containingItems[0].field_77994_a == 0) {
                                    this.containingItems[0] = null;
                                }
                            }
                        }
                    }
                }
            }
            this.produce();
            this.smeltItem();
            ++this.count;
            this.heatGJperTick = Math.min(Math.max(this.heatGJperTick, 0.0f), this.getMaxEnergyStoredGC());
        }
    }

    public void smeltItem() {
        if (this.canProcess()) {
            this.fuelTank.getFluidAmount();
            this.fuelTank.getCapacity();
            this.fuelTank.getFluidAmount();
            if (this.fuelTank.getFluid().getFluid() == GSFluids.BioFuel) {
                if (this.count >= 150) {
                    this.fuelTank.drain(1, true);
                    this.count = 0;
                }
            } else if (this.count >= 100) {
                this.fuelTank.drain(1, true);
                this.count = 0;
            }
            this.heatGJperTick = Math.min(this.heatGJperTick + Math.max(this.heatGJperTick * 0.005f, 0.3f), (float)MAX_GENERATE_GJ_PER_TICK);
        }
    }

    public boolean canProcess() {
        if (this.fuelTank.getFluidAmount() <= 0) {
            this.heatGJperTick = 0.0f;
            return false;
        }
        return this.storage.getEnergyStoredGC() < this.storage.getCapacityGC();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.itemCookTime = nbt.func_74762_e("itemCookTime");
        this.heatGJperTick = nbt.func_74762_e("generateRateInt");
        NBTTagList items = nbt.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int index = item.func_74771_c("Slot") & 0xFF;
            if (index >= this.containingItems.length) continue;
            this.containingItems[index] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("itemCookTime", this.itemCookTime);
        nbt.func_74776_a("generateRate", this.heatGJperTick);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.containingItems.length; ++i) {
            if (this.containingItems[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            this.containingItems[i].func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("Items", (NBTBase)items);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int slotIn) {
        return this.containingItems[slotIn];
    }

    public ItemStack func_70298_a(int index, int count_) {
        if (this.containingItems[index] == null) {
            return null;
        }
        if (this.containingItems[index].field_77994_a <= count_) {
            ItemStack stack = this.containingItems[index];
            this.containingItems[index] = null;
            return stack;
        }
        ItemStack stack = this.containingItems[index].func_77979_a(count_);
        if (this.containingItems[index].field_77994_a == 0) {
            this.containingItems[index] = null;
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        if (this.containingItems[index] != null) {
            ItemStack stack = this.containingItems[index];
            this.containingItems[index] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.containingItems[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.FuelGenerator.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == GCItems.bucketFuel || stack.func_77973_b() == GCItems.fuelCanister;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotID, ItemStack item, int side) {
        return this.func_94041_b(slotID, item);
    }

    public boolean func_102008_b(int slotID, ItemStack item, int side) {
        return slotID == 0;
    }

    public float receiveElectricity(ForgeDirection from, float energy, int tier, boolean doReceive) {
        return 0.0f;
    }

    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        return EnumSet.of(ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)));
    }

    public ForgeDirection getElectricalOutputDirectionMain() {
        return ForgeDirection.getOrientation((int)(this.func_145832_p() + 2));
    }

    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        return direction != null && !ForgeDirection.UNKNOWN.equals((Object)direction) && type == NetworkType.POWER && direction == this.getElectricalOutputDirectionMain();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)).getOpposite())) {
            String liquidName = FluidRegistry.getFluidName((FluidStack)resource);
            if (liquidName != null && liquidName.startsWith("fuel")) {
                used = this.fuelTank.fill(resource, doFill);
            }
            if (liquidName != null && liquidName.startsWith("biofuel")) {
                used = this.fuelTank.fill(resource, doFill);
            }
        }
        return used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.fuelTank.getFluid() == null || this.fuelTank.getFluidAmount() < this.fuelTank.getCapacity();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.fuelTank)};
    }
}

