/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.blocks;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.HEUtil;
import com.sinthoras.hydroenergy.api.IHEHasCustomMaterialCalculation;
import com.sinthoras.hydroenergy.client.HEClient;
import com.sinthoras.hydroenergy.config.HEConfig;
import com.sinthoras.hydroenergy.server.HEServer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class HEWater
extends BlockFluidBase
implements IHEHasCustomMaterialCalculation {
    private int waterId;

    public HEWater(int waterId) {
        super(FluidRegistry.WATER, Material.field_151586_h);
        this.waterId = waterId;
        this.func_149711_c(100.0f);
        this.func_149713_g(0);
        this.func_149663_c("water");
        this.func_149658_d("hydroenergy:" + HE.dummyTexture);
    }

    public FluidStack drain(World world, int blockX, int blockY, int blockZ, boolean doDrain) {
        return null;
    }

    public boolean canDrain(World world, int blockX, int blockY, int blockZ) {
        return false;
    }

    public int getQuantaValue(IBlockAccess world, int blockX, int blockY, int blockZ) {
        float waterLevelInBlock = this.getWaterLevel() - (float)blockY;
        waterLevelInBlock = HEUtil.clamp(waterLevelInBlock, 0.0f, 1.0f);
        return Math.round(waterLevelInBlock * 8.0f);
    }

    public Vec3 getFlowVector(IBlockAccess world, int x, int y, int z) {
        return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    }

    public boolean func_149678_a(int meta, boolean fullHit) {
        return false;
    }

    public int func_149717_k() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return 3;
        }
        return 0;
    }

    public int getMaxRenderHeightMeta() {
        return 0;
    }

    public float getWaterLevel() {
        if (HE.logicalClientLoaded) {
            return HEClient.getDam(this.waterId).getWaterLevelForPhysicsAndLighting();
        }
        return HEServer.instance.getWaterLevel(this.getWaterId());
    }

    public boolean canFlowInto(IBlockAccess world, int blockX, int blockY, int blockZ) {
        Block block = world.func_147439_a(blockX, blockY, blockZ);
        return block.func_149688_o() == Material.field_151579_a || this.canDisplace(world, blockX, blockY, blockZ) && !(block instanceof BlockLiquid) || block.func_149688_o() == Material.field_151586_h && !(block instanceof HEWater);
    }

    public int getWaterId() {
        return this.waterId;
    }

    public String func_149739_a() {
        return super.func_149739_a() + this.waterId;
    }

    @Override
    public Material getMaterial(int blockY) {
        return Math.floor(this.getWaterLevel() - HEConfig.clippingOffset) < (double)blockY ? Material.field_151579_a : Material.field_151586_h;
    }

    @Override
    public Material getMaterial(double blockY) {
        return (double)(this.getWaterLevel() + 0.12f) < blockY ? Material.field_151579_a : Material.field_151586_h;
    }
}

