/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.client.gui.widgets;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.client.HEDam;
import com.sinthoras.hydroenergy.client.gui.widgets.HEButtonTextured;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class HEWidgetModes
extends Gui {
    private static final Color nearBlack = new Color(16, 0, 16, 240);
    private static final Color lightPurple = new Color(80, 0, 255, 80);
    private static final Color darkPurple = new Color(40, 0, 127, 80);
    private final HEDam dam;
    private final int pixelX;
    private final int pixelY;
    private HEButtonTextured.Drain buttonDrain;
    private HEButtonTextured.Debug buttonDebug;
    private HEButtonTextured.Water buttonWater;
    private boolean isEnabled;

    public HEWidgetModes(HEDam dam, int pixelX, int pixelY) {
        this.dam = dam;
        this.pixelX = pixelX;
        this.pixelY = pixelY;
    }

    public void init(List<GuiButton> buttonList) {
        this.buttonDrain = new HEButtonTextured.Drain(0, this.pixelX, this.pixelY);
        this.buttonDebug = new HEButtonTextured.Debug(1, this.pixelX + 25, this.pixelY);
        this.buttonWater = new HEButtonTextured.Water(2, this.pixelX + 50, this.pixelY);
        buttonList.add(this.buttonDrain);
        buttonList.add(this.buttonDebug);
        buttonList.add(this.buttonWater);
    }

    public void actionPerformed(GuiButton button) {
        if (button == this.buttonDrain) {
            this.dam.setMode(HE.DamMode.DRAIN);
            this.dam.applyChanges();
        } else if (button == this.buttonDebug) {
            this.dam.setMode(HE.DamMode.DEBUG);
            this.dam.applyChanges();
        } else if (button == this.buttonWater) {
            this.dam.setMode(HE.DamMode.SPREAD);
            this.dam.applyChanges();
        }
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        if (isEnabled) {
            HE.DamMode mode = this.dam.getMode();
            this.buttonDrain.field_146124_l = mode != HE.DamMode.DRAIN;
            this.buttonDebug.field_146124_l = mode != HE.DamMode.DEBUG;
            this.buttonWater.field_146124_l = mode != HE.DamMode.SPREAD;
        } else {
            this.buttonDrain.field_146124_l = false;
            this.buttonDebug.field_146124_l = false;
            this.buttonWater.field_146124_l = false;
        }
        this.buttonDrain.field_146125_m = isEnabled;
        this.buttonDebug.field_146125_m = isEnabled;
        this.buttonWater.field_146125_m = isEnabled;
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY) {
        if (!this.isEnabled) {
            this.buttonDrain.field_146125_m = true;
            this.buttonDebug.field_146125_m = true;
            this.buttonWater.field_146125_m = true;
            this.buttonDrain.func_146112_a(minecraft, mouseX, mouseY);
            this.buttonDebug.func_146112_a(minecraft, mouseX, mouseY);
            this.buttonWater.func_146112_a(minecraft, mouseX, mouseY);
            this.buttonDrain.field_146125_m = false;
            this.buttonDebug.field_146125_m = false;
            this.buttonWater.field_146125_m = false;
        }
    }

    public void drawTooltip(FontRenderer fontRenderer, int mouseX, int mouseY, int screenWidth) {
        if (this.isEnabled) {
            if (this.buttonDrain.isOverButton(mouseX, mouseY)) {
                this.drawTooltip("Remove water from world", mouseX, mouseY, fontRenderer, screenWidth);
            }
            if (this.buttonDebug.isOverButton(mouseX, mouseY)) {
                this.drawTooltip("Spread and show all water", mouseX, mouseY, fontRenderer, screenWidth);
            }
            if (this.buttonWater.isOverButton(mouseX, mouseY)) {
                this.drawTooltip("Spread and show water", mouseX, mouseY, fontRenderer, screenWidth);
            }
        }
    }

    private void drawTooltip(String s, int mouseX, int mouseY, FontRenderer fontRenderer, int screenWidth) {
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        mouseX += 12;
        int stringWidth = fontRenderer.func_78256_a(s);
        mouseX -= Math.max(0, mouseX + stringWidth + 3 - screenWidth);
        this.func_73733_a(mouseX - 3, (mouseY += 12) - 4, mouseX + stringWidth + 3, mouseY - 3, nearBlack.getRGB(), nearBlack.getRGB());
        this.func_73733_a(mouseX - 3, mouseY + 11, mouseX + stringWidth + 3, mouseY + 12, nearBlack.getRGB(), nearBlack.getRGB());
        this.func_73733_a(mouseX - 3, mouseY - 3, mouseX + stringWidth + 3, mouseY + 11, nearBlack.getRGB(), nearBlack.getRGB());
        this.func_73733_a(mouseX - 4, mouseY - 3, mouseX - 3, mouseY + 11, nearBlack.getRGB(), nearBlack.getRGB());
        this.func_73733_a(mouseX + stringWidth + 3, mouseY - 3, mouseX + stringWidth + 4, mouseY + 11, nearBlack.getRGB(), nearBlack.getRGB());
        this.func_73733_a(mouseX - 3, mouseY - 2, mouseX - 2, mouseY + 10, lightPurple.getRGB(), darkPurple.getRGB());
        this.func_73733_a(mouseX + stringWidth + 2, mouseY - 2, mouseX + stringWidth + 3, mouseY + 10, lightPurple.getRGB(), darkPurple.getRGB());
        this.func_73733_a(mouseX - 3, mouseY - 3, mouseX + stringWidth + 3, mouseY - 2, lightPurple.getRGB(), lightPurple.getRGB());
        this.func_73733_a(mouseX - 3, mouseY + 10, mouseX + stringWidth + 3, mouseY + 11, darkPurple.getRGB(), darkPurple.getRGB());
        fontRenderer.func_78261_a(s, mouseX, mouseY, Color.WHITE.getRGB());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }
}

