/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.block;

import codechicken.lib.raytracer.ExtendedMOP;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import com.thecodewarrior.catwalks.CatwalkMod;
import com.thecodewarrior.catwalks.ICagedLadderConnectable;
import com.thecodewarrior.catwalks.ICustomLadder;
import com.thecodewarrior.catwalks.block.BlockSupportColumn;
import com.thecodewarrior.catwalks.item.ItemCautionTape;
import com.thecodewarrior.catwalks.item.ItemRopeLight;
import com.thecodewarrior.catwalks.util.CatwalkUtil;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCatwalk
extends Block
implements ICagedLadderConnectable,
ICustomLadder {
    public boolean lights;
    public boolean bottom;
    public boolean tape;
    private RayTracer rayTracer = new RayTracer();
    public static IIcon inventory_bottom;
    public static IIcon inventory_side;
    public static IIcon transparent;
    public static Map<TextureSide, Map<TextureType, IIcon>> textures;

    public BlockCatwalk(boolean lights, boolean bottom, boolean tape) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149672_a(CatwalkMod.catwalkSounds);
        this.func_149663_c("catwalk");
        if (!(lights || bottom || tape)) {
            this.func_149647_a(CatwalkMod.catwalkTab);
        }
        this.lights = lights;
        this.bottom = bottom;
        this.tape = tape;
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        float hardness = this.field_149782_v;
        if (player.func_70694_bm() != null) {
            boolean shouldBeSoft = false;
            if (CatwalkUtil.isHoldingWrench(player)) {
                shouldBeSoft = true;
            }
            if (shouldBeSoft) {
                hardness = this.field_149782_v / 10.0f;
            }
        }
        return player.getBreakSpeed((Block)this, false, metadata, x, y, z) / hardness / 30.0f;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (CatwalkUtil.isHoldingWrench(player) && player.func_70093_af()) {
            ArrayList<ItemStack> drops = this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            for (ItemStack s : drops) {
                CatwalkUtil.giveItemToPlayer(player, s);
            }
            this.updateNeighborSides(world, x, y, z, false);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int blockSide, float hitX, float hitY, float hitZ) {
        MovingObjectPosition hit = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (int)x, (int)y, (int)z);
        ForgeDirection side = ForgeDirection.UP;
        if (hit != null) {
            side = (ForgeDirection)((ExtendedMOP)hit).data;
        }
        if (player.func_71045_bC() != null) {
            Item item = player.func_71045_bC().func_77973_b();
            boolean use = false;
            if (side == ForgeDirection.DOWN && world.func_147439_a(x, y - 1, z) instanceof BlockSupportColumn && item instanceof ItemBlock && ((ItemBlock)item).field_150939_a instanceof BlockSupportColumn) {
                return world.func_147439_a(x, y - 1, z).func_149727_a(world, x, y - 1, z, player, ForgeDirection.UP.ordinal(), hitX, 1.0f, hitZ);
            }
            if (CatwalkUtil.isHoldingWrench(player)) {
                if (side != ForgeDirection.UP) {
                    this.updateData(world, x, y, z, side, !this.getOpenState((IBlockAccess)world, x, y, z, side), this.lights, this.tape);
                }
            } else if (item instanceof ItemRopeLight && !this.lights) {
                this.updateData(world, x, y, z, ForgeDirection.UP, false, true, this.tape);
                use = true;
            } else if (item instanceof ItemCautionTape && !this.tape) {
                this.updateData(world, x, y, z, ForgeDirection.UP, false, this.lights, true);
                use = true;
            }
            if (use && !player.field_71075_bZ.field_75098_d) {
                --player.func_71045_bC().field_77994_a;
            }
        }
        if (player.func_71045_bC() == null && player.func_70093_af()) {
            if (this.lights) {
                if (!world.field_72995_K) {
                    CatwalkUtil.giveItemToPlayer(player, new ItemStack(CatwalkMod.itemRopeLight, 1));
                    this.updateData(world, x, y, z, ForgeDirection.UP, false, false, this.tape);
                }
            } else if (this.tape && !world.field_72995_K) {
                CatwalkUtil.giveItemToPlayer(player, new ItemStack(CatwalkMod.itemCautionTape, 1));
                this.updateData(world, x, y, z, ForgeDirection.UP, false, this.lights, false);
            }
        }
        return false;
    }

    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase e, ItemStack s) {
        this.updateNeighborSides(w, x, y, z, true);
    }

    public void func_149664_b(World w, int x, int y, int z, int meta) {
        this.updateNeighborSides(w, x, y, z, false);
    }

    public void func_149723_a(World w, int x, int y, int z, Explosion e) {
        this.updateNeighborSides(w, x, y, z, false);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(Item.func_150898_a((Block)CatwalkMod.defaultCatwalk), 1));
        if (this.lights) {
            ret.add(new ItemStack(CatwalkMod.itemRopeLight, 1));
        }
        return ret;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        return this.collisionRayTrace(world, x, y, z, CatwalkMod.proxy.getPlayerLooking(start, end), start, end);
    }

    public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, EntityPlayer player, Vec3 start, Vec3 end) {
        ExtendedMOP mop;
        Block below;
        LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
        boolean hasWrench = true;
        if (player != null) {
            hasWrench = CatwalkUtil.isHoldingWrench(player);
        }
        float px = 0.0625f;
        int meta = world.func_72805_g(x, y, z);
        boolean ovr = false;
        double d = 0.0;
        float smallHeight = 0.25f;
        d = this.bottom ? 0.125 : ((below = world.func_147439_a(x, y - 1, z)) instanceof BlockCatwalk || below instanceof BlockSupportColumn ? 0.4 : 0.25);
        if (this.bottom || hasWrench) {
            cuboids.add(new IndexedCuboid6((Object)ForgeDirection.DOWN, new Cuboid6((double)x + d, (double)(y + 0), (double)z + d, (double)(x + 1) - d, (double)((float)y + px), (double)(z + 1) - d)));
        }
        float ym = 1.0f;
        ym = !this.getBit(meta, 3) || ovr ? 1.0f : smallHeight;
        if (!this.getBit(meta, 3) || hasWrench) {
            cuboids.add(new IndexedCuboid6((Object)ForgeDirection.NORTH, new Cuboid6((double)(x + 0), (double)(y + 0), (double)(z + 0), (double)(x + 1), (double)((float)y + ym), (double)((float)z + px))));
        }
        ym = !this.getBit(meta, 2) || ovr ? 1.0f : smallHeight;
        if (!this.getBit(meta, 2) || hasWrench) {
            cuboids.add(new IndexedCuboid6((Object)ForgeDirection.SOUTH, new Cuboid6((double)(x + 0), (double)(y + 0), (double)((float)(z + 1) - px), (double)(x + 1), (double)((float)y + ym), (double)(z + 1))));
        }
        ym = !this.getBit(meta, 1) || ovr ? 1.0f : smallHeight;
        if (!this.getBit(meta, 1) || hasWrench) {
            cuboids.add(new IndexedCuboid6((Object)ForgeDirection.WEST, new Cuboid6((double)(x + 0), (double)(y + 0), (double)(z + 0), (double)((float)x + px), (double)((float)y + ym), (double)(z + 1))));
        }
        ym = !this.getBit(meta, 0) || ovr ? 1.0f : smallHeight;
        if (!this.getBit(meta, 0) || hasWrench) {
            cuboids.add(new IndexedCuboid6((Object)ForgeDirection.EAST, new Cuboid6((double)((float)(x + 1) - px), (double)(y + 0), (double)(z + 0), (double)(x + 1), (double)((float)y + ym), (double)(z + 1))));
        }
        if ((mop = (ExtendedMOP)this.rayTracer.rayTraceCuboids(new Vector3(start), new Vector3(end), cuboids, new BlockCoord(x, y, z), (Block)this)) != null && mop.field_72310_e == ((ForgeDirection)mop.data).getOpposite().ordinal()) {
            mop.field_72310_e = ((ForgeDirection)mop.data).ordinal();
        }
        return mop;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        World world = event.player.field_70170_p;
        MovingObjectPosition mop = event.target;
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) == this) {
            RayTracer.retraceBlock((World)world, (EntityPlayer)event.player, (int)mop.field_72311_b, (int)mop.field_72312_c, (int)mop.field_72309_d);
        }
    }

    public boolean shouldHaveBox(World world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.DOWN || !world.isSideSolid(x + side.offsetX, y + side.offsetY, z + side.offsetZ, side.getOpposite(), false);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB blockBounds, List list, Entity collidingEntity) {
        if (collidingEntity == null) {
            return;
        }
        float px = 0.0625f;
        int meta = world.func_72805_g(x, y, z);
        float top = 1.5f;
        if (collidingEntity.func_70093_af()) {
            top = 1.0f;
        }
        boolean override = false;
        Cuboid6 oldBounds = new Cuboid6(this.func_149704_x(), this.func_149665_z(), this.func_149706_B(), this.func_149753_y(), this.func_149669_A(), this.func_149693_C());
        if (this.bottom && this.shouldHaveBox(world, x, y, z, ForgeDirection.DOWN)) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.2f, 1.0f);
            super.func_149743_a(world, x, y, z, blockBounds, list, collidingEntity);
        }
        if (!this.getBit(meta, 3) && this.shouldHaveBox(world, x, y, z, ForgeDirection.NORTH) || override) {
            if (this.shouldSideBeShort(world, x, y, z, ForgeDirection.NORTH)) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, px);
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, top, px);
            }
            super.func_149743_a(world, x, y, z, blockBounds, list, collidingEntity);
        }
        if (!this.getBit(meta, 2) && this.shouldHaveBox(world, x, y, z, ForgeDirection.SOUTH) || override) {
            if (this.shouldSideBeShort(world, x, y, z, ForgeDirection.SOUTH)) {
                this.func_149676_a(0.0f, 0.0f, 1.0f - px, 1.0f, 1.0f, 1.0f);
            } else {
                this.func_149676_a(0.0f, 0.0f, 1.0f - px, 1.0f, top, 1.0f);
            }
            super.func_149743_a(world, x, y, z, blockBounds, list, collidingEntity);
        }
        if (!this.getBit(meta, 1) && this.shouldHaveBox(world, x, y, z, ForgeDirection.WEST) || override) {
            if (this.shouldSideBeShort(world, x, y, z, ForgeDirection.WEST)) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, px, 1.0f, 1.0f);
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, px, top, 1.0f);
            }
            super.func_149743_a(world, x, y, z, blockBounds, list, collidingEntity);
        }
        if (!this.getBit(meta, 0) && this.shouldHaveBox(world, x, y, z, ForgeDirection.EAST) || override) {
            if (this.shouldSideBeShort(world, x, y, z, ForgeDirection.EAST)) {
                this.func_149676_a(1.0f - px, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else {
                this.func_149676_a(1.0f - px, 0.0f, 0.0f, 1.0f, top, 1.0f);
            }
            super.func_149743_a(world, x, y, z, blockBounds, list, collidingEntity);
        }
        oldBounds.setBlockBounds((Block)this);
    }

    public boolean shouldSideBeShort(World w, int x, int y, int z, ForgeDirection direction) {
        if (w.func_147439_a(x, y - 1, z) instanceof BlockCatwalk && !this.bottom) {
            return true;
        }
        int newX = x + direction.offsetX;
        int newY = y + 1;
        int newZ = z + direction.offsetZ;
        Block rawBlock = w.func_147439_a(newX, newY, newZ);
        int meta = w.func_72805_g(newX, newY, newZ);
        if (rawBlock instanceof BlockCatwalk) {
            BlockCatwalk b = (BlockCatwalk)rawBlock;
            return b.getOpenState((IBlockAccess)w, newX, newY, newZ, direction.getOpposite());
        }
        return false;
    }

    public boolean func_149655_b(IBlockAccess p_149655_1_, int p_149655_2_, int p_149655_3_, int p_149655_4_) {
        return false;
    }

    public void func_149651_a(IIconRegister reg) {
        if (this != CatwalkMod.defaultCatwalk) {
            return;
        }
        transparent = reg.func_94245_a("catwalks:transparent");
        inventory_bottom = reg.func_94245_a("catwalks:inventory/catwalk_bottom");
        inventory_side = reg.func_94245_a("catwalks:inventory/catwalk_side");
        textures = new HashMap<TextureSide, Map<TextureType, IIcon>>();
        for (TextureSide side : TextureSide.values()) {
            HashMap<TextureType, IIcon> sideMap = new HashMap<TextureType, IIcon>();
            textures.put(side, sideMap);
            for (TextureType type : TextureType.values()) {
                IIcon icon = reg.func_94245_a("catwalks:catwalk/" + side.filename + "/" + type.filename);
                sideMap.put(type, icon);
            }
        }
    }

    public IIcon func_149691_a(int _side, int meta) {
        if (_side >= 100) {
            ForgeDirection side = ForgeDirection.getOrientation((int)(_side - 100));
            if (side == ForgeDirection.UP) {
                return transparent;
            }
            if (side == ForgeDirection.DOWN) {
                return inventory_bottom;
            }
            return inventory_side;
        }
        ForgeDirection side = ForgeDirection.getOrientation((int)_side);
        if (side == ForgeDirection.UP) {
            return transparent;
        }
        TextureSide tSide = TextureSide.fromFD(side);
        TextureType type = TextureType.fromLightsAndTape(this.lights, this.tape);
        return textures.get((Object)tSide).get((Object)type);
    }

    public IIcon getLightIcon(int _side, int meta) {
        ForgeDirection side = ForgeDirection.getOrientation((int)_side);
        if (side == ForgeDirection.UP) {
            return transparent;
        }
        TextureSide tSide = TextureSide.fromFD(side);
        return textures.get((Object)tSide).get((Object)(this.tape ? TextureType.T_LIGHTS : TextureType.LIGHTS));
    }

    public boolean isSideSolid(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return false;
        }
        if (side == ForgeDirection.DOWN) {
            return this.bottom;
        }
        return !this.getOpenState(w, x, y, z, side);
    }

    public boolean calcSideRender(ForgeDirection target, IBlockAccess w, int x, int y, int z, ForgeDirection side, boolean manual) {
        if (target != side) {
            return false;
        }
        Block b = w.func_147439_a(x, y, z);
        if (b instanceof BlockCatwalk && !manual) {
            return false;
        }
        if (w.isSideSolid(x, y, z, side.getOpposite(), false) && !(b instanceof BlockCatwalk)) {
            return false;
        }
        return manual;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess w, int x, int y, int z, int _side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)_side);
        int meta = w.func_72805_g(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ);
        if (this.calcSideRender(ForgeDirection.DOWN, w, x, y, z, dir, this.bottom)) {
            return true;
        }
        if (this.calcSideRender(ForgeDirection.NORTH, w, x, y, z, dir, !this.getBit(meta, 3))) {
            return true;
        }
        if (this.calcSideRender(ForgeDirection.SOUTH, w, x, y, z, dir, !this.getBit(meta, 2))) {
            return true;
        }
        if (this.calcSideRender(ForgeDirection.WEST, w, x, y, z, dir, !this.getBit(meta, 1))) {
            return true;
        }
        return this.calcSideRender(ForgeDirection.EAST, w, x, y, z, dir, !this.getBit(meta, 0));
    }

    public int func_149750_m() {
        return this.lights ? CatwalkMod.lightLevel : 0;
    }

    public int setBit(int val, int pos, boolean value) {
        if (value) {
            return val | 1 << pos;
        }
        return val & ~(1 << pos);
    }

    public boolean getBit(int val, int pos) {
        return (val & 1 << pos) > 0;
    }

    public void updateNeighborSides(World w, int x, int y, int z, boolean updateSelf) {
        ForgeDirection dir;
        int i;
        for (i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            dir = ForgeDirection.VALID_DIRECTIONS[i];
            int newX = x + dir.offsetX;
            int newY = y + dir.offsetY;
            int newZ = z + dir.offsetZ;
            Block b = w.func_147439_a(newX, newY, newZ);
            if (!(b instanceof BlockCatwalk)) continue;
            ((BlockCatwalk)b).updateOpenStatus(w, newX, newY, newZ, dir.getOpposite());
        }
        if (updateSelf) {
            for (i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                dir = ForgeDirection.VALID_DIRECTIONS[i];
                this.updateOpenStatus(w, x, y, z, dir);
            }
            this.updateOpenStatus(w, x, y, z, ForgeDirection.DOWN);
        }
    }

    public void updateOpenStatus(World w, int x, int y, int z, ForgeDirection side) {
        this.updateData(w, x, y, z, side, this.shouldBeOpen(w, x, y, z, side), this.lights, this.tape);
    }

    public void updateData(World w, int x, int y, int z, ForgeDirection side, boolean state, boolean lights, boolean tape) {
        int meta = w.func_72805_g(x, y, z);
        if (side == ForgeDirection.NORTH) {
            meta = this.setBit(meta, 3, state);
        }
        if (side == ForgeDirection.SOUTH) {
            meta = this.setBit(meta, 2, state);
        }
        if (side == ForgeDirection.WEST) {
            meta = this.setBit(meta, 1, state);
        }
        if (side == ForgeDirection.EAST) {
            meta = this.setBit(meta, 0, state);
        }
        boolean bottom = this.bottom;
        if (side == ForgeDirection.DOWN) {
            bottom = !state;
        }
        Block block = CatwalkMod.catwalks.get(lights).get(bottom).get(tape);
        w.func_147465_d(x, y, z, block, meta, 3);
    }

    public boolean shouldBeOpen(World w, int x, int y, int z, ForgeDirection direction) {
        int newX = x + direction.offsetX;
        int newY = y + direction.offsetY;
        int newZ = z + direction.offsetZ;
        return w.func_147439_a(newX, newY, newZ) instanceof BlockCatwalk;
    }

    public boolean getOpenState(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        int meta = w.func_72805_g(x, y, z);
        if (side == ForgeDirection.DOWN && !this.bottom) {
            return true;
        }
        if (side == ForgeDirection.NORTH && (meta & 8) > 0) {
            return true;
        }
        if (side == ForgeDirection.SOUTH && (meta & 4) > 0) {
            return true;
        }
        if (side == ForgeDirection.WEST && (meta & 2) > 0) {
            return true;
        }
        return side == ForgeDirection.EAST && (meta & 1) > 0;
    }

    public int func_149645_b() {
        return CatwalkMod.catwalkRenderType;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean shouldConnectToSide(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        return this.getOpenState(w, x, y, z, side);
    }

    @Override
    public boolean shouldHaveBottom(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        if (this.bottom) {
            return true;
        }
        Block b = w.func_147439_a(x, y - 1, z);
        if (b instanceof ICagedLadderConnectable) {
            return ((ICagedLadderConnectable)b).doesSideHaveWall(w, x, y, z, side);
        }
        return false;
    }

    @Override
    public boolean doesSideHaveWall(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        return !this.getOpenState(w, x, y, z, side);
    }

    @Override
    public boolean isThin(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    @Override
    public double getLadderVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return 0.1;
    }

    @Override
    public double getLadderFallVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return -1.0;
    }

    @Override
    public boolean isOnLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        Block above = world.func_147439_a(x, y + 1, z);
        Block below = world.func_147439_a(x, y - 1, z);
        return below instanceof BlockCatwalk && !this.bottom || above instanceof BlockCatwalk && !((BlockCatwalk)above).bottom;
    }

    @Override
    public boolean shouldPlayStepSound(IBlockAccess world, int x, int y, int z, EntityLivingBase entity, boolean isMovingDown) {
        return !isMovingDown;
    }

    @Override
    public boolean shouldHoldOn(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return entity.func_70093_af() || CatwalkUtil.isHoldingWrench(entity, false);
    }

    @Override
    public boolean shouldClimbDown(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return entity.func_70093_af() && CatwalkUtil.isHoldingWrench(entity, false);
    }

    @Override
    public double getClimbDownVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return 0.03;
    }

    public static enum TextureType {
        LIGHTS("plain/lights"),
        T_LIGHTS("tape/lights"),
        W_LIGHTS("plain/w_lights"),
        WO_LIGHTS("plain/no_lights"),
        T_W_LIGHTS("tape/w_lights"),
        T_WO_LIGHTS("tape/no_lights");

        public String filename;

        private TextureType(String filename) {
            this.filename = filename;
        }

        public static TextureType fromLightsAndTape(boolean lights, boolean tape) {
            if (!lights && !tape) {
                return WO_LIGHTS;
            }
            if (lights && !tape) {
                return W_LIGHTS;
            }
            if (!lights && tape) {
                return T_WO_LIGHTS;
            }
            if (lights && tape) {
                return T_W_LIGHTS;
            }
            return WO_LIGHTS;
        }
    }

    public static enum TextureSide {
        BOTTOM("bottom"),
        SIDE("side");

        public String filename;

        private TextureSide(String filename) {
            this.filename = filename;
        }

        public static TextureSide fromFD(ForgeDirection side) {
            switch (side) {
                case DOWN: {
                    return BOTTOM;
                }
                case NORTH: 
                case SOUTH: 
                case EAST: 
                case WEST: {
                    return SIDE;
                }
            }
            return BOTTOM;
        }
    }
}

