/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.item;

import codechicken.lib.vec.BlockCoord;
import com.thecodewarrior.catwalks.block.BlockCagedLadder;
import com.thecodewarrior.catwalks.block.BlockCatwalk;
import com.thecodewarrior.catwalks.block.BlockSupportColumn;
import com.thecodewarrior.catwalks.util.BiPredicates;
import com.thecodewarrior.catwalks.util.CatwalkUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemBlockSupportColumn
extends ItemBlock {
    public static final BiPredicate<BlockCoord, World> hasSupportColumnAt = BiPredicates.hasLoadedBlockMatching(ItemBlockSupportColumn::isSupportColumn);

    public ItemBlockSupportColumn(Block b) {
        super(b);
    }

    private static boolean isSupportColumn(Block block) {
        return block instanceof BlockSupportColumn;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int _side, float hitX, float hitY, float hitZ) {
        ForgeDirection side;
        Block block = world.func_147439_a(x, y, z);
        if (this.shouldExtendExistingScaffold(block, world, x, side = ForgeDirection.getOrientation((int)_side), y, z)) {
            x += side.offsetX;
            y += side.offsetY;
            z += side.offsetZ;
            hitX -= (float)side.offsetX;
            hitY -= (float)side.offsetY;
            hitZ -= (float)side.offsetZ;
            _side = side.getOpposite().ordinal();
        }
        return CatwalkUtil.extendBlock(stack, player, world, x, y, z, _side, hitX, hitY, hitZ, this, ItemBlockSupportColumn::isSupportColumn, hasSupportColumnAt, BiPredicates.never());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_150936_a(World world, int x, int y, int z, int _side, EntityPlayer player, ItemStack stack) {
        ForgeDirection side;
        Block block = world.func_147439_a(x, y, z);
        if (this.shouldExtendExistingScaffold(block, world, x, side = ForgeDirection.getOrientation((int)_side), y, z)) {
            x += side.offsetX;
            y += side.offsetY;
            z += side.offsetZ;
            _side = side.getOpposite().ordinal();
        }
        return CatwalkUtil.canPlaceBlock(stack, player, world, x, y, z, _side, this, ItemBlockSupportColumn::isSupportColumn, hasSupportColumnAt, BiPredicates.never());
    }

    private boolean shouldExtendExistingScaffold(Block block, World world, int x, ForgeDirection side, int y, int z) {
        return (block instanceof BlockCatwalk || block instanceof BlockCagedLadder) && world.func_147439_a(x + side.offsetX, y + side.offsetY, z + side.offsetZ) instanceof BlockSupportColumn;
    }
}

