/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import cofh.lib.util.helpers.MathHelper;
import com.enderio.core.client.gui.widget.GhostSlot;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.gui.item.ItemConduitFilterContainer;
import crazypants.enderio.conduit.gui.item.LimitedItemFilterGui;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.conduit.item.filter.FuzzyMode;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import java.util.List;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ItemFilterLimited
extends ItemFilter {
    public ItemFilterLimited() {
        this(10, true);
    }

    public ItemFilterLimited(int numItems, boolean isAdvanced) {
        super(numItems, isAdvanced);
    }

    @Override
    public String func_145825_b() {
        return "Limited Item Filter";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemFilterGui getGui(GuiExternalConnection gui, IItemConduit itemConduit, boolean isInput) {
        ItemConduitFilterContainer cont = new ItemConduitFilterContainer(itemConduit, gui.getDir(), isInput);
        LimitedItemFilterGui limitedItemFilterGui = new LimitedItemFilterGui(gui, cont, !isInput, isInput);
        limitedItemFilterGui.createFilterSlots();
        return limitedItemFilterGui;
    }

    @Override
    public void createGhostSlots(List<GhostSlot> slots, int xOffset, int yOffset, Runnable cb) {
        int index = 0;
        int numRows = (int)((double)(this.items.length / 5));
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < 5; ++col) {
                int x = xOffset + col * 18;
                int y = yOffset + row * 20;
                slots.add(new ItemFilterGhostSlot(index, x, y, cb));
                ++index;
            }
        }
    }

    @Override
    public int getMaxCountThatCanPassFilter(ItemStack item) {
        if (item == null || item.func_77973_b() == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.items.length; ++i) {
            ItemStack invStack = this.items[i];
            if (invStack == null || !this.itemStackMatched(invStack, item, i)) continue;
            count += invStack.field_77994_a;
        }
        return count;
    }

    @Override
    public boolean isLimited() {
        return true;
    }

    public int getInsertLimit(ISidedInventory inv, ItemStack item) {
        if (item == null || item.func_77973_b() == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack invStack = inv.func_70301_a(i);
            if (invStack == null || !this.itemStackMatched(invStack, item, i)) continue;
            count += invStack.field_77994_a;
        }
        return this.getMaxCountThatCanPassFilter(item) - count;
    }

    public int getInsertLimitInv(ISidedInventory inv, ItemStack item) {
        return -this.getInsertLimit(inv, item);
    }

    public boolean doesCountPassFilter(int maxCount) {
        return maxCount > 0;
    }

    @Override
    public boolean doesItemPassFilter(NetworkedInventory inv, ItemStack item) {
        return this.isValid() && this.itemMatched(item) && this.doesCountPassFilter(this.getInsertLimit(inv.getInventory(), item));
    }

    public boolean doesItemPassFilterInv(NetworkedInventory inv, ItemStack item) {
        return this.isValid() && this.itemMatched(item) && this.doesCountPassFilter(this.getInsertLimitInv(inv.getInventory(), item));
    }

    protected boolean itemStackMatched(ItemStack item, ItemStack filter, int slot) {
        if (item == null) {
            return false;
        }
        boolean checkDamage = this.fuzzyMode != FuzzyMode.DISABLED;
        boolean damageMatched = false;
        if (checkDamage && item.func_77973_b().func_77645_m()) {
            damageMatched = this.fuzzyMode.compare(item);
        }
        if (this.isItemListEmpty()) {
            if (checkDamage) {
                return damageMatched;
            }
            return false;
        }
        boolean matched = false;
        if (filter != null && item.func_77973_b() == filter.func_77973_b()) {
            matched = true;
            if (checkDamage && !damageMatched) {
                matched = false;
            } else if (this.matchMeta && item.func_77960_j() != filter.func_77960_j()) {
                matched = false;
            } else if (this.matchNBT && !this.isNBTMatch(item, filter)) {
                matched = false;
            }
        }
        if (!matched && this.useOreDict && this.isOreDicMatch(filter, item)) {
            matched = true;
        }
        return matched;
    }

    public boolean isOreDicMatch(ItemStack filter, ItemStack item) {
        int[] id_filter = OreDictionary.getOreIDs((ItemStack)filter);
        if (id_filter.length == 0) {
            return false;
        }
        int[] id_item = OreDictionary.getOreIDs((ItemStack)item);
        if (id_item.length == 0) {
            return false;
        }
        for (int id1 : id_filter) {
            for (int id2 : id_item) {
                if (id1 != id2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack func_70298_a(int fromSlot, int amount) {
        if (fromSlot < 0 || fromSlot >= this.items.length) {
            return null;
        }
        this.oreIds.set(fromSlot, null);
        ItemStack item = this.items[fromSlot];
        this.items[fromSlot] = null;
        return item.func_77979_a(amount);
    }

    @Override
    public String toString() {
        return "Limited" + super.toString();
    }

    @Override
    public String getUnlocalizedName() {
        return "gui.limited_item_filter";
    }

    class ItemFilterGhostSlot
    extends GhostSlot {
        private final int slot;
        private final Runnable cb;
        private final int adjustOnShift;

        ItemFilterGhostSlot(int slot, int x, int y, Runnable cb) {
            this.x = x;
            this.y = y;
            this.slot = slot;
            this.cb = cb;
            this.displayStdOverlay = true;
            this.stackSizeLimit = 64;
            this.adjustOnShift = 10;
        }

        public void putStack(ItemStack stack) {
            if (stack != null) {
                stack = stack.func_77946_l();
                if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                    if (Mouse.isButtonDown((int)0) || Mouse.getEventDWheel() > 0) {
                        stack.field_77994_a = stack.field_77994_a - 1 == 1 ? (stack.field_77994_a += this.adjustOnShift - 2) : MathHelper.clamp((int)(stack.field_77994_a + this.adjustOnShift - 1), (int)1, (int)stack.func_77976_d());
                    } else if (Mouse.isButtonDown((int)1) || Mouse.getEventDWheel() < 0) {
                        stack.field_77994_a = stack.field_77994_a + 1 == 1 ? ++stack.field_77994_a : MathHelper.clamp((int)(stack.field_77994_a - this.adjustOnShift + 1), (int)1, (int)stack.func_77976_d());
                    }
                }
            }
            ItemFilterLimited.this.items[this.slot] = stack;
            this.cb.run();
        }

        public ItemStack getStack() {
            return ItemFilterLimited.this.items[this.slot];
        }
    }
}

