/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.packet;

import com.enderio.core.common.util.DyeColor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.conduit.oc.IOCConduit;
import crazypants.enderio.conduit.packet.AbstractConduitPacket;
import crazypants.enderio.conduit.packet.ConTypeEnum;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketOCConduitSignalColor
extends AbstractConduitPacket<IOCConduit>
implements IMessageHandler<PacketOCConduitSignalColor, IMessage> {
    private ForgeDirection dir;
    private DyeColor col;

    public PacketOCConduitSignalColor() {
    }

    public PacketOCConduitSignalColor(IOCConduit con, ForgeDirection dir) {
        super(con.getBundle().getEntity(), ConTypeEnum.OC);
        this.dir = dir;
        this.col = con.getSignalColor(dir);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.dir.ordinal());
        buf.writeShort(this.col.ordinal());
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.dir = ForgeDirection.values()[buf.readShort()];
        this.col = DyeColor.values()[buf.readShort()];
    }

    public IMessage onMessage(PacketOCConduitSignalColor message, MessageContext ctx) {
        if (PacketOCConduitSignalColor.isInvalidPacketForGui(message, ctx)) {
            return null;
        }
        ((IOCConduit)message.getTileCasted(ctx)).setSignalColor(message.dir, message.col);
        message.getWorld(ctx).func_147471_g(message.x, message.y, message.z);
        return null;
    }
}

