/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.weather;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.machine.obelisk.weather.ContainerWeatherObelisk;
import crazypants.enderio.machine.obelisk.weather.PacketActivateWeather;
import crazypants.enderio.machine.obelisk.weather.PacketControlModeWeather;
import crazypants.enderio.machine.obelisk.weather.TileWeatherObelisk;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import java.awt.Rectangle;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class GuiWeatherObelisk
extends GuiPoweredMachineBase<TileWeatherObelisk> {
    private IconButton buttonStart;
    private ToggleButton buttonMode;

    public GuiWeatherObelisk(InventoryPlayer inventory, TileWeatherObelisk tileEntity) {
        super(tileEntity, (Container)new ContainerWeatherObelisk(inventory, tileEntity), "weatherObelisk");
        this.addProgressTooltip(79, 29, 18, 31);
        this.addToolTip(new GuiToolTip(new Rectangle(22, 11, 16, 63), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                FluidTank tank = ((TileWeatherObelisk)GuiWeatherObelisk.this.getTileEntity()).getInputTank();
                String heading = EnderIO.lang.localize("tank.tank");
                if (tank.getFluid() != null) {
                    heading = heading + ": " + tank.getFluid().getLocalizedName();
                }
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((TileWeatherObelisk)GuiWeatherObelisk.this.getTileEntity()).getInputTank()));
            }
        });
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x_mode = this.field_146999_f - 5 - 16;
        int x_start = this.field_146999_f / 2 - 8;
        int y = 58;
        this.buttonMode = new ToggleButton((IGuiScreen)this, 1, x_mode, y, (IWidgetIcon)IconEIO.TICK, (IWidgetIcon)IconEIO.REDSTONE_MODE_WITH_SIGNAL);
        this.buttonMode.setToolTip(new String[]{EnderIO.lang.localize("gui.machine.weather.control")});
        this.buttonMode.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.machine.weather.redstone")});
        this.buttonMode.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.machine.weather.manual")});
        this.buttonMode.setSelected(((TileWeatherObelisk)this.getTileEntity()).getLaunchOnRedstone());
        this.addButton((GuiButton)this.buttonMode);
        this.buttonMode.onGuiInit();
        this.buttonStart = new IconButton((IGuiScreen)this, 0, x_start, y, (IWidgetIcon)IconEIO.MINUS);
        this.buttonStart.setToolTip(new String[]{EnderIO.lang.localize("gui.machine.weather.run")});
        this.addButton((GuiButton)this.buttonStart);
        this.buttonStart.onGuiInit();
        this.refreshButtons();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (((TileWeatherObelisk)this.getTileEntity()).func_145831_w().func_82737_E() % 20L == 0L) {
            this.refreshButtons();
        }
    }

    private void refreshButtons() {
        boolean pulseControl = ((TileWeatherObelisk)this.getTileEntity()).getLaunchOnRedstone();
        this.pulseControlAction(pulseControl);
        TileWeatherObelisk.WeatherTask task = this.getCurrentTask();
        if (task == null) {
            this.buttonStart.setIcon((IWidgetIcon)IconEIO.MINUS);
            this.buttonStart.field_146124_l = false;
            return;
        }
        switch (task) {
            case CLEAR: {
                this.buttonStart.setIcon((IWidgetIcon)IconEIO.SUN);
                break;
            }
            case RAIN: {
                this.buttonStart.setIcon((IWidgetIcon)IconEIO.RAIN);
                break;
            }
            case STORM: {
                this.buttonStart.setIcon((IWidgetIcon)IconEIO.THUNDER);
            }
        }
    }

    protected TileWeatherObelisk.WeatherTask getCurrentTask() {
        FluidStack fs = ((TileWeatherObelisk)this.getTileEntity()).getInputTank().getFluid();
        if (fs == null) {
            return null;
        }
        return TileWeatherObelisk.WeatherTask.fromFluid(fs.getFluid());
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        this.bindGuiTexture();
        this.func_73729_b(this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        int x = this.getGuiLeft() + 22;
        int y = this.getGuiTop() + 11;
        RenderUtil.renderGuiTank((FluidTank)((TileWeatherObelisk)this.getTileEntity()).getInputTank(), (double)x, (double)y, (double)0.0, (double)16.0, (double)63.0);
        this.bindGuiTexture();
        this.func_73729_b(x, y, 186, 33, 16, 63);
        if (this.shouldRenderProgress() && ((TileWeatherObelisk)this.getTileEntity()).getActiveTask() != null) {
            int barHeight = this.getProgressScaled(31);
            Color color = ((TileWeatherObelisk)this.getTileEntity()).getActiveTask().color;
            GL11.glColor3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
            this.func_73729_b(this.getGuiLeft() + 81, this.getGuiTop() + 58 - barHeight, this.getXSize(), 32 - barHeight, 12, barHeight);
        }
        super.func_146976_a(par1, par2, par3);
    }

    @Override
    protected int getPowerHeight() {
        return 63;
    }

    @Override
    protected int getPowerU() {
        return super.getPowerU();
    }

    @Override
    protected int getPowerV() {
        return 33;
    }

    @Override
    protected int getPowerX() {
        return super.getPowerX() - 7;
    }

    @Override
    protected int getPowerY() {
        return super.getPowerY() - 3;
    }

    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        if (b.field_146127_k == 0) {
            ((TileWeatherObelisk)this.getTileEntity()).startTask();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketActivateWeather((TileWeatherObelisk)this.getTileEntity(), true));
            this.buttonStart.setEnabled(false);
        } else if (b.field_146127_k == 1) {
            boolean pulseControl = this.buttonMode.isSelected();
            ((TileWeatherObelisk)this.getTileEntity()).setLaunchOnRedstone(pulseControl);
            this.pulseControlAction(pulseControl);
            PacketControlModeWeather packet = new PacketControlModeWeather((TileWeatherObelisk)this.getTileEntity());
            PacketHandler.INSTANCE.sendToServer((IMessage)packet);
        }
    }

    protected void pulseControlAction(boolean pulseControl) {
        this.redstoneButton.setVisible(!pulseControl);
        this.buttonStart.setEnabled(!pulseControl && ((TileWeatherObelisk)this.getTileEntity()).canStartTask(this.getCurrentTask()));
    }
}

