/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.network;

import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.Log;
import crazypants.enderio.machine.gui.IContainerWithTileEntity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;

public class PacketUtil {
    public static boolean isInvalidPacketForGui(MessageContext ctx, TileEntity receivedTile, Class<?> messageClass) {
        if (receivedTile == null) {
            return true;
        }
        if (ctx.side == Side.CLIENT) {
            return false;
        }
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        Container container = player.field_71070_bA;
        if (!(container instanceof IContainerWithTileEntity)) {
            Log.LOGGER.warn(Log.securityMarker, "Player {} tried to send {} while not opening correct GUI. Target TileEntity at {}, {}, {}", new Object[]{player.func_146103_bH(), messageClass.getSimpleName(), receivedTile.field_145851_c, receivedTile.field_145848_d, receivedTile.field_145849_e});
            return true;
        }
        TileEntity expectedTile = ((IContainerWithTileEntity)container).getTileEntity();
        if (receivedTile != expectedTile) {
            Log.LOGGER.warn(Log.securityMarker, "Player {} tried to send {} which attempts to modify setting of TileEntity at {}, {}, {}. Expected: {}, {}, {}", new Object[]{player.func_146103_bH(), messageClass.getSimpleName(), receivedTile.field_145851_c, receivedTile.field_145848_d, receivedTile.field_145849_e, expectedTile.field_145851_c, expectedTile.field_145848_d, expectedTile.field_145849_e});
            return true;
        }
        return false;
    }
}

