/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.neid.asm;

import com.gtnewhorizons.neid.asm.AsmTransformException;
import com.gtnewhorizons.neid.asm.FieldNotFoundException;
import com.gtnewhorizons.neid.asm.MethodNotFoundException;
import com.gtnewhorizons.neid.asm.Name;
import java.util.ListIterator;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class AsmUtil
implements Opcodes {
    public static MethodNode findMethod(ClassNode cn, String name) {
        return AsmUtil.findMethod(cn, name, false);
    }

    public static MethodNode findMethod(ClassNode cn, String name, boolean optional) {
        for (MethodNode methodNode : cn.methods) {
            if (!methodNode.name.equals(name)) continue;
            return methodNode;
        }
        if (optional) {
            return null;
        }
        throw new MethodNotFoundException(name);
    }

    public static MethodNode findMethod(ClassNode cn, Name name) {
        return AsmUtil.findMethod(cn, name, false);
    }

    public static MethodNode findMethod(ClassNode cn, Name name, boolean optional) {
        for (MethodNode methodNode : cn.methods) {
            if (!name.matches(methodNode)) continue;
            return methodNode;
        }
        if (optional) {
            return null;
        }
        throw new MethodNotFoundException(name.deobf);
    }

    public static FieldNode findField(ClassNode cn, String name, boolean optional) {
        for (FieldNode fieldNode : cn.fields) {
            if (!name.equals(fieldNode.name)) continue;
            return fieldNode;
        }
        if (optional) {
            return null;
        }
        throw new FieldNotFoundException(name);
    }

    public static void modifyIntConstantInMethod(MethodNode method, int oldValue, int newValue) {
        AsmUtil.modifyIntConstantInMethod(method, oldValue, newValue, false);
    }

    public static boolean modifyIntConstantInMethod(MethodNode method, int oldValue, int newValue, boolean optional) {
        boolean found = false;
        boolean foundOnce = false;
        ListIterator it = method.instructions.iterator();
        while (it.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)it.next();
            if (insn.getOpcode() == 3 && oldValue == 0) {
                found = true;
            } else if (insn.getOpcode() == 4 && oldValue == 1) {
                found = true;
            } else if (insn.getOpcode() == 5 && oldValue == 2) {
                found = true;
            } else if (insn.getOpcode() == 6 && oldValue == 3) {
                found = true;
            } else if (insn.getOpcode() == 7 && oldValue == 4) {
                found = true;
            } else if (insn.getOpcode() == 8 && oldValue == 5) {
                found = true;
            } else if (insn.getOpcode() == 18) {
                LdcInsnNode node = (LdcInsnNode)insn;
                if (node.cst instanceof Integer && (Integer)node.cst == oldValue) {
                    found = true;
                }
            } else if (insn.getOpcode() == 17 || insn.getOpcode() == 16) {
                IntInsnNode node2 = (IntInsnNode)insn;
                if (node2.operand == oldValue) {
                    found = true;
                }
            }
            if (!found) continue;
            foundOnce = true;
            if (newValue == 0) {
                it.set(new InsnNode(3));
            } else if (newValue == 1) {
                it.set(new InsnNode(4));
            } else if (newValue == 2) {
                it.set(new InsnNode(5));
            } else if (newValue == 3) {
                it.set(new InsnNode(6));
            } else if (newValue == 4) {
                it.set(new InsnNode(7));
            } else if (newValue == 5) {
                it.set(new InsnNode(8));
            } else if (newValue >= -128 && newValue <= 127) {
                it.set(new IntInsnNode(16, newValue));
            } else if (newValue >= Short.MIN_VALUE && newValue <= Short.MAX_VALUE) {
                it.set(new IntInsnNode(17, newValue));
            } else {
                it.set(new LdcInsnNode((Object)newValue));
            }
            found = false;
        }
        if (!foundOnce && !optional) {
            throw new AsmTransformException("can't find constant value " + oldValue + " in method " + method.name);
        }
        return foundOnce;
    }
}

