/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatComponentTranslationFormatException;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import serverutils.lib.command.CmdBase;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.StringUtils;

public class CmdDumpStats
extends CmdBase {
    private static final File statDumpFile = new File("serverutilities/server/stat_dump.txt");

    public CmdDumpStats() {
        super("dump_stats", CmdBase.Level.OP_OR_SP);
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        FileUtils.delete(statDumpFile);
        ArrayList<String> output = new ArrayList<String>();
        List stats = StatList.field_75940_b;
        ArrayList<String> achievementStats = new ArrayList<String>();
        ArrayList<String> craftStats = new ArrayList<String>();
        ArrayList<String> useStats = new ArrayList<String>();
        ArrayList<String> itemsBrokeStats = new ArrayList<String>();
        ArrayList<String> blocksMinedStats = new ArrayList<String>();
        ArrayList<String> miscStats = new ArrayList<String>();
        for (StatBase stat : stats) {
            String statId = stat.field_75975_e;
            if (statId.startsWith("stat.entityKilledBy") || statId.startsWith("stat.killEntity")) continue;
            String statStr = this.getStatString(stat);
            if (statId.contains("achievement.")) {
                achievementStats.add(statStr);
                continue;
            }
            if (statId.contains("craftItem.")) {
                craftStats.add(statStr);
                continue;
            }
            if (statId.contains("useItem.")) {
                useStats.add(statStr);
                continue;
            }
            if (statId.contains("breakItem.")) {
                itemsBrokeStats.add(statStr);
                continue;
            }
            if (statId.contains("mineBlock.")) {
                blocksMinedStats.add(statStr);
                continue;
            }
            miscStats.add(statStr);
        }
        ArrayList<String> killStats = new ArrayList<String>();
        for (EntityList.EntityEggInfo eggInfo : EntityList.field_75627_a.values()) {
            String killedById = eggInfo.field_151513_e == null ? "null" : eggInfo.field_151513_e.field_75975_e;
            String killsId = eggInfo.field_151512_d == null ? "null" : eggInfo.field_151512_d.field_75975_e;
            String entityArg = StatCollector.func_74838_a((String)("entity." + EntityList.func_75617_a((int)eggInfo.field_75613_a) + ".name"));
            killStats.add(killedById + " || " + StatCollector.func_74837_a((String)"stat.entityKilledBy", (Object[])new Object[]{entityArg, 0}));
            killStats.add(killsId + " || " + StatCollector.func_74837_a((String)"stat.entityKills", (Object[])new Object[]{0, entityArg}));
        }
        this.addSection(output, "Misc. Stats", miscStats);
        this.addSection(output, "Achievement Stats", achievementStats);
        this.addSection(output, "Craft Stats", craftStats);
        this.addSection(output, "Use Stats", useStats);
        this.addSection(output, "Items Broke Stats", itemsBrokeStats);
        this.addSection(output, "Blocks Mined Stats", blocksMinedStats);
        this.addSection(output, "Kill Stats", killStats);
        FileUtils.saveSafe(statDumpFile, output);
        sender.func_145747_a((IChatComponent)new ChatComponentText("Dumped " + stats.size() + " stats to file " + statDumpFile.getPath()));
    }

    private String getStatString(StatBase stat) {
        String base = stat.field_75975_e + " || ";
        IChatComponent statName = stat.field_75978_a;
        if (statName instanceof ChatComponentTranslation) {
            ChatComponentTranslation translation = (ChatComponentTranslation)statName;
            try {
                return base + translation.func_150260_c();
            }
            catch (ChatComponentTranslationFormatException e) {
                return base + stat.field_75975_e;
            }
        }
        return base + statName.func_150260_c();
    }

    private void addSection(List<String> output, String title, List<String> stats) {
        output.add("--------------------");
        output.add(title);
        output.add("--------------------");
        stats.sort(StringUtils.IGNORE_CASE_COMPARATOR);
        output.addAll(stats);
    }
}

